/**
 * Copyright (c) 2007-2012, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Borland) - [243151] explicit source/target for links
 *                           - #386838 - migrate to Xtend2
 * Vincent Lorenzo (CEA-LIST) -
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.commands.DeleteLinkCommand;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import utils.UtilsItemSemanticEditPolicy;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class LinkItemSemanticEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;
  
  @Inject
  private BaseItemSemanticEditPolicy xptBaseItemSemanticEditPolicy;
  
  @Inject
  private linkCommands xptLinkCommands;
  
  @Inject
  private DeleteLinkCommand xptDeleteLinkCommand;
  
  @Inject
  @Extension
  private DeleteLinkCommand _deleteLinkCommand;
  
  @Inject
  @Extension
  private UtilsItemSemanticEditPolicy _utilsItemSemanticEditPolicy;
  
  public CharSequence className(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _itemSemanticEditPolicyClassName = it.getItemSemanticEditPolicyClassName();
    _builder.append(_itemSemanticEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence LinkItemSemanticEditPolicy(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends ");
    CharSequence _qualifiedClassName = this.xptBaseItemSemanticEditPolicy.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _defaultConstructor = this.xptBaseItemSemanticEditPolicy.defaultConstructor(it);
    _builder.append(_defaultConstructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _classBody = this.classBody(it);
    _builder.append(_classBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence classBody(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _destroySemanticCommand = this.getDestroySemanticCommand(it.getModelFacet(), it);
    _builder.append(_destroySemanticCommand);
    _builder.newLineIfNotEmpty();
    {
      boolean _isTypeLink = this._linkUtils_qvto.isTypeLink(it);
      if (_isTypeLink) {
        CharSequence _linkCommands = this.xptLinkCommands.linkCommands(it);
        _builder.append(_linkCommands);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getDestroySemanticCommand(final LinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unsupported model facet: " + it) + ", for link: ") + genLink));
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _getDestroySemanticCommand(final FeatureLinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.commands.Command getDestroyReferenceCommand(org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest req) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getGEFWrapper(");
    CharSequence _newDeleteReferenceLinkCommand = this.xptDeleteLinkCommand.newDeleteReferenceLinkCommand(it, genLink, "req");
    _builder.append(_newDeleteReferenceLinkCommand, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _getDestroySemanticCommand(final TypeLinkModelFacet it, final GenLink genLink) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      boolean _isUsingDeleteService = genLink.isUsingDeleteService();
      if (_isUsingDeleteService) {
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _destroyElementCommandByService = this._utilsItemSemanticEditPolicy.getDestroyElementCommandByService(it);
        _builder.append(_destroyElementCommandByService, "\t");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gef.commands.Command getDestroyElementCommand(org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest req) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand cmd = new org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand(getEditingDomain(), null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cmd.setTransactionNestingEnabled(true);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java.util.List<org.eclipse.emf.ecore.EObject> todestroy=new java.util.ArrayList<org.eclipse.emf.ecore.EObject>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("todestroy.add(req.getElementToDestroy());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//cmd.add(new org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand(req));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cmd.add(new org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper(new org.eclipse.emf.edit.command.DeleteCommand(getEditingDomain(),todestroy )));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getGEFWrapper(cmd.reduce());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//return getGEFWrapper(");
        CharSequence _newDeleteLinkWithClassCommand = this._deleteLinkCommand.newDeleteLinkWithClassCommand(it, genLink, "req");
        _builder.append(_newDeleteLinkWithClassCommand, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence additions(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence getDestroySemanticCommand(final LinkModelFacet it, final GenLink genLink) {
    if (it instanceof FeatureLinkModelFacet) {
      return _getDestroySemanticCommand((FeatureLinkModelFacet)it, genLink);
    } else if (it instanceof TypeLinkModelFacet) {
      return _getDestroySemanticCommand((TypeLinkModelFacet)it, genLink);
    } else if (it != null) {
      return _getDestroySemanticCommand(it, genLink);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, genLink).toString());
    }
  }
}
