/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests.apireport;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.CodePointTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SafeDeltaXmlVisitor
extends DeltaVisitor {
    private Document fDoc;
    private Element fDeltas;
    public CharSequenceTranslator ESCAPE_XML11 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.BASIC_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.APOS_ESCAPE()), new LookupTranslator((CharSequence[][])new String[][]{{"\u0000", ""}, {"\u000b", "&#11;"}, {"\f", "&#12;"}, {"\ufffe", ""}, {"\uffff", ""}}), NumericEntityEscaper.between((int)1, (int)8), NumericEntityEscaper.between((int)14, (int)31), NumericEntityEscaper.between((int)127, (int)132), NumericEntityEscaper.between((int)134, (int)159), new UnicodeUnpairedSurrogateRemover()});

    public SafeDeltaXmlVisitor() throws CoreException {
        this.fDoc = Util.newDocument();
        this.fDeltas = this.fDoc.createElement("deltas");
        this.fDoc.appendChild(this.fDeltas);
    }

    public boolean visit(IDelta delta) {
        if (delta == ApiComparator.NO_DELTA) {
            return false;
        }
        if (delta.getChildren().length == 0) {
            this.processLeafDelta(delta);
        }
        return true;
    }

    protected void processLeafDelta(IDelta delta) {
        Element deltaElement = this.fDoc.createElement("delta");
        deltaElement.setAttribute("flags", Integer.toString(delta.getFlags()));
        deltaElement.setAttribute("kind", Util.getDeltaKindName((IDelta)delta));
        deltaElement.setAttribute("element_type", Util.getDeltaElementType((IDelta)delta));
        deltaElement.setAttribute("key", delta.getKey());
        String typeName = delta.getTypeName();
        if (typeName != null) {
            deltaElement.setAttribute("type_name", typeName);
        }
        deltaElement.setAttribute("compatible", Boolean.toString(DeltaProcessor.isCompatible((IDelta)delta)));
        deltaElement.setAttribute("oldModifiers", Integer.toString(delta.getOldModifiers()));
        deltaElement.setAttribute("newModifiers", Integer.toString(delta.getNewModifiers()));
        deltaElement.setAttribute("restrictions", Integer.toString(delta.getCurrentRestrictions()));
        String apiComponentID = delta.getComponentVersionId();
        if (apiComponentID != null) {
            deltaElement.setAttribute("componentId", apiComponentID);
        }
        deltaElement.setAttribute("message", this.ESCAPE_XML11.translate((CharSequence)delta.getMessage()));
        String[] messageArguments = delta.getArguments();
        int length = messageArguments.length;
        if (length > 0) {
            Element messageArgumentsElement = this.fDoc.createElement("message_arguments");
            int j = 0;
            while (j < length) {
                Element messageArgumentElement = this.fDoc.createElement("message_argument");
                messageArgumentElement.setAttribute("value", this.ESCAPE_XML11.translate((CharSequence)String.valueOf(messageArguments[j])));
                messageArgumentsElement.appendChild(messageArgumentElement);
                ++j;
            }
            deltaElement.appendChild(messageArgumentsElement);
        }
        this.fDeltas.appendChild(deltaElement);
    }

    public void endVisit(IDelta delta) {
    }

    public String getXML() throws CoreException {
        return Util.serializeDocument((Document)this.fDoc);
    }

    public Document getDocument() {
        return this.fDoc;
    }

    public class UnicodeUnpairedSurrogateRemover
    extends CodePointTranslator {
        public boolean translate(int codepoint, Writer out) throws IOException {
            return codepoint <= 57343 && codepoint >= 55296;
        }
    }
}

