/**
 * Copyright (c) 2015 Anatoliy Tischenko and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Anatoliy Tischenko - Initial API and implementation
 */
package aspects.metamodel;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import metamodel.MetaModel_qvto;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
@SuppressWarnings("all")
public class MetaModel extends metamodel.MetaModel {
  @Inject
  @Extension
  private MetaModel_qvto _metaModel_qvto;
  
  @Override
  public CharSequence DeclareAndAssign2(final GenClass it, final String assignee, final String src, final GenClass srcMetaClass, final GenFeature srcFeature, final String srcExt, final boolean needCast) {
    StringConcatenation _builder = new StringConcatenation();
    String _qualifiedInterfaceName = this._metaModel_qvto.getQualifiedInterfaceName(it);
    _builder.append(_qualifiedInterfaceName);
    _builder.append(" ");
    _builder.append(assignee);
    _builder.append(" = ");
    CharSequence _featureValue = this.getFeatureValue(srcFeature, src, srcMetaClass);
    _builder.append(_featureValue);
    _builder.append(".");
    _builder.append(srcExt);
    _builder.append(";");
    return _builder;
  }
}
