/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.parameters.defaultvalue;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.robotics.parameters.utils.ParameterTableUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DefaultValueTableCellManager
extends AbstractCellManager {
    private static final String DEFAULT_VALUE = "Default value";
    private static final String TYPE = "Type";
    private static final String NAME = "Name";
    private static final String DESC = "Description";
    public static final String DEFAULT_VALUE_TABLE = "DefaultValueTable";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager mngr) {
        EObject parent;
        return columnElement instanceof IAxis && (parent = ((IAxis)columnElement).eContainer()) != null && (parent = parent.eContainer()) instanceof Table && ((Table)parent).getTableConfiguration().getType().equals(DEFAULT_VALUE_TABLE);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager mngr) {
        Property p;
        boolean isEditable = false;
        if (rowElement instanceof Property && (p = (Property)rowElement).upperBound() == 1) {
            isEditable = true;
        }
        return isEditable;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        String alias;
        String value = "";
        String string = alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        if (rowElement instanceof Property && alias != null) {
            ParameterEntry parameter;
            Property p = (Property)rowElement;
            if (alias.equals(NAME)) {
                return p.getName();
            }
            if (alias.equals(TYPE)) {
                Type type = p.getType();
                return type != null ? type.getName() : "undefined";
            }
            if (alias.equals(DEFAULT_VALUE)) {
                if (p != null && p.getDefault() != null) {
                    return p.getDefault();
                }
            } else if (alias.equals(DESC) && p != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)p, ParameterEntry.class)) != null) {
                return parameter.getDescription();
            }
        }
        return value;
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, final Object newValue, INattableModelManager tableManager) {
        String text;
        String alias = columnElement instanceof IAxis ? ((IAxis)columnElement).getAlias() : null;
        Property property = (Property)rowElement;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)property);
        CompositeCommand editingCommand = new CompositeCommand(null);
        if (newValue instanceof Type) {
            SetRequest setTypeReq = new SetRequest(domain, (EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)((Type)newValue));
            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setTypeReq));
        } else if (alias.equals(DESC)) {
            ParameterEntry parameter;
            if (property != null && (parameter = (ParameterEntry)UMLUtil.getStereotypeApplication((Element)property, ParameterEntry.class)) != null) {
                return new RecordingCommand(TransactionUtil.getEditingDomain((EObject)property)){

                    protected void doExecute() {
                        parameter.setDescription((String)newValue);
                    }
                };
            }
        } else if (newValue instanceof String && (text = (String)newValue) != null) {
            if (alias.equals(NAME)) {
                SetRequest setNameReq = new SetRequest(domain, (EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)text);
                editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)setNameReq));
            } else if (alias.equals(DEFAULT_VALUE)) {
                text = StringUtils.unquote((String)text);
                if (property.getDefaultValue() instanceof OpaqueExpression) {
                    OpaqueExpression expression = (OpaqueExpression)property.getDefaultValue();
                    if (provider != null) {
                        EList bodies = expression.getBodies();
                        ArrayList<String> newBodies = new ArrayList<String>();
                        newBodies.add(text);
                        if (!bodies.isEmpty()) {
                            newBodies.addAll(bodies.subList(1, bodies.size()));
                        } else {
                            ArrayList<String> newLanguages = new ArrayList<String>();
                            newLanguages.add("Matlab");
                            SetRequest languageRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Language(), newLanguages);
                            editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)languageRequest));
                        }
                        SetRequest bodiesRequest = new SetRequest(domain, (EObject)expression, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Body(), newBodies);
                        editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)bodiesRequest));
                    }
                } else {
                    ValueSpecification specification = ParameterTableUtils.createValueSpecification((Element)property, property.getType(), text);
                    if (specification != null && provider != null) {
                        SetRequest request = new SetRequest(domain, (EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)specification);
                        editingCommand.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
                    }
                }
            }
        }
        return new GMFtoEMFCommandWrapper((ICommand)editingCommand);
    }
}

