/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.ArrayList;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tree;

public class GraphLib {
    public static final String LABEL = "label";
    public static final Schema LABEL_SCHEMA = new Schema();

    static {
        LABEL_SCHEMA.addColumn(LABEL, String.class, "");
    }

    private GraphLib() {
    }

    public static Graph getNodes(int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        int i = 0;
        while (i < n) {
            Node node = g.addNode();
            node.setString(LABEL, String.valueOf(i));
            ++i;
        }
        return g;
    }

    public static Graph getStar(int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = g.addNode();
        r.setString(LABEL, "0");
        int i = 1;
        while (i <= n) {
            Node nn = g.addNode();
            nn.setString(LABEL, String.valueOf(i));
            g.addEdge(r, nn);
            ++i;
        }
        return g;
    }

    public static Graph getClique(int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodes = new Node[n];
        int i = 0;
        while (i < n) {
            nodes[i] = g.addNode();
            nodes[i].setString(LABEL, String.valueOf(i));
            ++i;
        }
        i = 0;
        while (i < n) {
            int j = i;
            while (j < n) {
                if (i != j) {
                    g.addEdge(nodes[i], nodes[j]);
                }
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph getGrid(int m, int n) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodes = new Node[m * n];
        int i = 0;
        while (i < m * n) {
            nodes[i] = g.addNode();
            nodes[i].setString(LABEL, String.valueOf(i));
            if (i >= n) {
                g.addEdge(nodes[i - n], nodes[i]);
            }
            if (i % n != 0) {
                g.addEdge(nodes[i - 1], nodes[i]);
            }
            ++i;
        }
        return g;
    }

    public static Graph getHoneycomb(int levels) {
        Graph g = new Graph();
        g.getNodeTable().addColumns(LABEL_SCHEMA);
        ArrayList layer1 = GraphLib.halfcomb(g, levels);
        ArrayList layer2 = GraphLib.halfcomb(g, levels);
        int i = 0;
        while (i < levels << 1) {
            Node n1 = (Node)layer1.get(i);
            Node n2 = (Node)layer2.get(i);
            g.addEdge(n1, n2);
            ++i;
        }
        return g;
    }

    private static ArrayList halfcomb(Graph g, int levels) {
        Node n;
        ArrayList<Node> top = new ArrayList<Node>();
        ArrayList<Node> layer = new ArrayList<Node>();
        int label = 0;
        int i = 0;
        while (i < levels) {
            n = g.addNode();
            n.setString(LABEL, String.valueOf(label++));
            top.add(n);
            ++i;
        }
        i = 0;
        while (i < levels) {
            Node p;
            n = null;
            int j = 0;
            while (j < top.size()) {
                p = (Node)top.get(j);
                if (n == null) {
                    n = g.addNode();
                    n.setString(LABEL, String.valueOf(label++));
                    layer.add(n);
                }
                g.addEdge(p, n);
                n = g.addNode();
                n.setString(LABEL, String.valueOf(label++));
                layer.add(n);
                g.addEdge(p, n);
                ++j;
            }
            if (i == levels - 1) {
                return layer;
            }
            top.clear();
            j = 0;
            while (j < layer.size()) {
                p = (Node)layer.get(j);
                n = g.addNode();
                n.setString(LABEL, String.valueOf(label++));
                top.add(n);
                g.addEdge(p, n);
                ++j;
            }
            layer.clear();
            ++i;
        }
        return top;
    }

    public static Tree getBalancedTree(int breadth, int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        if (depth > 0) {
            GraphLib.balancedHelper(t, r, breadth, depth - 1);
        }
        return t;
    }

    private static void balancedHelper(Tree t, Node n, int breadth, int depth) {
        int i = 0;
        while (i < breadth) {
            Node c = t.addChild(n);
            c.setString(LABEL, String.valueOf(i) + "," + c.getDepth());
            if (depth > 0) {
                GraphLib.balancedHelper(t, c, breadth, depth - 1);
            }
            ++i;
        }
    }

    public static Tree getLeftDeepTree(int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        GraphLib.deepHelper(t, r, 2, depth, true);
        return t;
    }

    public static Tree getRightDeepTree(int depth) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        GraphLib.deepHelper(t, r, 2, depth, false);
        return t;
    }

    public static Tree getDiamondTree(int b, int d1, int d2) {
        Tree t = new Tree();
        t.getNodeTable().addColumns(LABEL_SCHEMA);
        Node r = t.addRoot();
        r.setString(LABEL, "0,0");
        Node left = t.addChild(r);
        left.setString(LABEL, "1,0");
        Node right = t.addChild(r);
        right.setString(LABEL, "1,1");
        GraphLib.deepHelper(t, left, b, d1 - 2, true);
        GraphLib.deepHelper(t, right, b, d1 - 2, false);
        while (left.getFirstChild() != null) {
            left = left.getFirstChild();
        }
        while (right.getLastChild() != null) {
            right = right.getLastChild();
        }
        GraphLib.deepHelper(t, left, b, d2 - 1, false);
        GraphLib.deepHelper(t, right, b, d2 - 1, true);
        return t;
    }

    private static void deepHelper(Tree t, Node n, int breadth, int depth, boolean left) {
        Node c = t.addChild(n);
        c.setString(LABEL, "0," + c.getDepth());
        if (left && depth > 0) {
            GraphLib.deepHelper(t, c, breadth, depth - 1, left);
        }
        int i = 1;
        while (i < breadth) {
            c = t.addChild(n);
            c.setString(LABEL, String.valueOf(i) + "," + c.getDepth());
            ++i;
        }
        if (!left && depth > 0) {
            GraphLib.deepHelper(t, c, breadth, depth - 1, left);
        }
    }
}

