/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class FeatureMaps2wayMergeTest {
    private IndividualDiffInputData input = new IndividualDiffInputData();
    private final BatchMerger batchMerger = new BatchMerger(IMerger.RegistryImpl.createStandaloneInstance());

    @Test
    public void test2wayContainmentAdd_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentAdd_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentAdd_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertEquals((long)0L, (long)((Collection)firstKey).size());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)map).size(eSFFirstKey));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentAdd_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftAddScope();
        Resource right = this.input.getFeatureMapContainmentRightAddScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertEquals((long)0L, (long)((Collection)firstKey).size());
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)map).size(eSFFirstKey));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentDelete_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertEquals((long)0L, (long)((Collection)firstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)map).size(eSFFirstKey));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentDelete_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNull((Object)rightNode2);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertEquals((long)0L, (long)((Collection)firstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)map).size(eSFFirstKey));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentDelete_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentDelete_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftDeleteScope();
        Resource right = this.input.getFeatureMapContainmentRightDeleteScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode2));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode2));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentKeyChange_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentKeyChange_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentKeyChange_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object secondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(secondKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)secondKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentKeyChange_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFSecondKey = leftMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object secondKey = leftMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(secondKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)secondKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMove_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMove_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMove_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMove_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode2 = this.getNodeNamed(left, "mapNode2");
        Assert.assertNotNull((Object)leftMapNode2);
        EStructuralFeature eSFFirstKey = leftMapNode2.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode2.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(leftNode1));
        EStructuralFeature eSFmap = leftMapNode2.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode2.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)leftNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveOrder_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)firstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveOrder_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)firstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveOrder_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)firstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveOrder_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveOrderScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveOrderScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNode1");
        Assert.assertNotNull((Object)leftMapNode1);
        EStructuralFeature eSFFirstKey = leftMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)firstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)firstKey).get(0));
        EStructuralFeature eSFmap = leftMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)map).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)map).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveKeyChange_LtR_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveKeyChange_LtR_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKey");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object firstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFFirstKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveKeyChange_RtL_1() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFSecondKey = rightMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object firstKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveKeyChange_RtL_2() throws IOException {
        Resource left = this.input.getFeatureMapContainmentLeftMoveKeyChangeScope();
        Resource right = this.input.getFeatureMapContainmentRightMoveKeyChangeScope();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNode2");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFSecondKey = rightMapNode1.eClass().getEStructuralFeature("secondKey");
        Assert.assertNotNull((Object)eSFSecondKey);
        Object firstKey = rightMapNode1.eGet(eSFSecondKey);
        Assert.assertTrue((boolean)(firstKey instanceof Collection));
        Assert.assertTrue((boolean)((Collection)firstKey).contains(rightNode1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("map");
        Assert.assertNotNull((Object)eSFmap);
        Object map = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(map instanceof BasicFeatureMap));
        Assert.assertTrue((boolean)((BasicFeatureMap)map).basicContains(eSFSecondKey, (Object)rightNode1));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveToInside_RtL() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        for (Diff diff : differences) {
            this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveToInside_LtR() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        for (Diff diff : differences) {
            this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveToOutside_LtR() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff featureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(FeatureMapChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)));
        Diff referenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)featureMapChangeDiff))}));
        Assert.assertEquals((long)2L, (long)featureMapChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)referenceChangeDiff.getEquivalence().getDifferences().size());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(featureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllLeftToRight(Arrays.asList(referenceChangeDiff), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayContainmentMoveToOutside_RtL() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapContainmentMoveOutside((ResourceSet)resourceSet);
        Resource right = this.input.getFeatureMapContainmentMoveInside((ResourceSet)resourceSet);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff featureMapChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(FeatureMapChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE)));
        Diff referenceChangeDiff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), Predicates.not((Predicate)EMFComparePredicates.isEquivalentTo((Diff)featureMapChangeDiff))}));
        Assert.assertEquals((long)2L, (long)featureMapChangeDiff.getEquivalence().getDifferences().size());
        Assert.assertEquals((long)2L, (long)referenceChangeDiff.getEquivalence().getDifferences().size());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(featureMapChangeDiff), (Monitor)new BasicMonitor());
        this.batchMerger.copyAllRightToLeft(Arrays.asList(referenceChangeDiff), (Monitor)new BasicMonitor());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentAdd_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentAdd_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentAdd_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentAdd_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftAddScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightAddScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentDelete_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentDelete_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)leftFirstKey).size());
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)0L, (long)((List)rightFirstKey).size());
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)leftMap).size());
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)0L, (long)((BasicFeatureMap)rightMap).size());
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentDelete_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentDelete_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftDeleteScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightDeleteScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode2 = this.getNodeNamed(left, "node2");
        Assert.assertNotNull((Object)leftNode2);
        EObject rightNode2 = this.getNodeNamed(right, "node2");
        Assert.assertNotNull((Object)rightNode2);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode2, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)1L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode2, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode2, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)1L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode2, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentMoveOrder_LtR_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentMoveOrder_LtR_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(1));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(1));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 1, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 1, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentMoveOrder_RtL_1() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(ReferenceChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    @Test
    public void test2wayNonContainmentMoveOrder_RtL_2() throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource left = this.input.getFeatureMapNonContainmentLeftMoveOrderScope((ResourceSet)rs);
        Resource right = this.input.getFeatureMapNonContainmentRightMoveOrderScope((ResourceSet)rs);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff = (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE), (Predicate)Predicates.instanceOf(FeatureMapChange.class)));
        this.batchMerger.copyAllRightToLeft(Arrays.asList(diff), (Monitor)new BasicMonitor());
        EObject leftNode1 = this.getNodeNamed(left, "node1");
        Assert.assertNotNull((Object)leftNode1);
        EObject rightNode1 = this.getNodeNamed(right, "node1");
        Assert.assertNotNull((Object)rightNode1);
        EObject leftMapNode1 = this.getNodeNamed(left, "mapNC1");
        Assert.assertNotNull((Object)leftMapNode1);
        EObject rightMapNode1 = this.getNodeNamed(right, "mapNC1");
        Assert.assertNotNull((Object)rightMapNode1);
        EStructuralFeature eSFFirstKey = rightMapNode1.eClass().getEStructuralFeature("firstKeyNC");
        Assert.assertNotNull((Object)eSFFirstKey);
        Object leftFirstKey = leftMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(leftFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)leftFirstKey).size());
        Assert.assertEquals((Object)leftNode1, ((List)leftFirstKey).get(0));
        Object rightFirstKey = rightMapNode1.eGet(eSFFirstKey);
        Assert.assertTrue((boolean)(rightFirstKey instanceof List));
        Assert.assertEquals((long)2L, (long)((List)rightFirstKey).size());
        Assert.assertEquals((Object)rightNode1, ((List)rightFirstKey).get(0));
        EStructuralFeature eSFmap = rightMapNode1.eClass().getEStructuralFeature("mapNC");
        Assert.assertNotNull((Object)eSFmap);
        Object leftMap = leftMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(leftMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)leftMap).size());
        Assert.assertEquals((Object)leftNode1, (Object)((BasicFeatureMap)leftMap).get(eSFFirstKey, 0, true));
        Object rightMap = rightMapNode1.eGet(eSFmap);
        Assert.assertTrue((boolean)(rightMap instanceof BasicFeatureMap));
        Assert.assertEquals((long)2L, (long)((BasicFeatureMap)rightMap).size());
        Assert.assertEquals((Object)rightNode1, (Object)((BasicFeatureMap)rightMap).get(eSFFirstKey, 0, true));
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
    }

    private EObject getNodeNamed(Resource res, String name) {
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)res, (boolean)false);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            EStructuralFeature nameFeature = next.eClass().getEStructuralFeature("name");
            if (nameFeature == null || !name.equals(next.eGet(nameFeature))) continue;
            return next;
        }
        return null;
    }
}

