/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockAreaImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockChangeInfoImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockDeltaImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockStateImpl;
import org.eclipse.emf.cdo.internal.common.lock.DurableCDOLockOwner;
import org.eclipse.emf.cdo.internal.common.lock.NormalCDOLockOwner;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public final class CDOLockUtil {
    public static final int DURABLE_SESSION_ID = 0;
    public static final int DURABLE_VIEW_ID = 0;
    public static final CDOLockState[] NO_LOCK_STATES = new CDOLockState[0];
    public static final CDOLockDelta[] NO_LOCK_DELTAS = new CDOLockDelta[0];

    private CDOLockUtil() {
    }

    public static CDOID getLockedObjectID(Object lockedObject) {
        if (lockedObject instanceof CDOID) {
            return (CDOID)lockedObject;
        }
        if (lockedObject instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)lockedObject).getID();
        }
        return null;
    }

    public static CDOBranch getLockedObjectBranch(Object lockedObject) {
        if (lockedObject instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)lockedObject).getBranch();
        }
        return null;
    }

    public static int indexOf(CDOLockOwner[] lockOwners, CDOLockOwner lockOwner) {
        int i = 0;
        while (i < lockOwners.length) {
            if (lockOwners[i] == lockOwner) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static CDOLockState convertLockState(RWOLockManager.LockState<Object, ? extends CDOCommonView> lockState) {
        CDOCommonView writeOptionOwner;
        CDOLockStateImpl cdoLockState = new CDOLockStateImpl(lockState.getLockedObject());
        for (CDOCommonView readLockOwner : lockState.getReadLockOwners()) {
            cdoLockState.addOwner(CDOLockUtil.createLockOwner(readLockOwner), IRWLockManager.LockType.READ);
        }
        CDOCommonView writeLockOwner = (CDOCommonView)lockState.getWriteLockOwner();
        if (writeLockOwner != null) {
            cdoLockState.addOwner(CDOLockUtil.createLockOwner(writeLockOwner), IRWLockManager.LockType.WRITE);
        }
        if ((writeOptionOwner = (CDOCommonView)lockState.getWriteOptionOwner()) != null) {
            cdoLockState.addOwner(CDOLockUtil.createLockOwner(writeOptionOwner), IRWLockManager.LockType.OPTION);
        }
        return cdoLockState;
    }

    public static CDOLockState createLockState(Object target) {
        return new CDOLockStateImpl(target);
    }

    public static CDOLockOwner createLockOwner(CDOCommonView view) {
        int sessionID = view.getSessionID();
        int viewID = view.getViewID();
        String durableLockingID = view.getDurableLockingID();
        return CDOLockUtil.createLockOwner(sessionID, viewID, durableLockingID);
    }

    public static CDOLockOwner createLockOwner(int sessionID, int viewID, String durableLockingID) {
        if (durableLockingID != null) {
            return DurableCDOLockOwner.create(sessionID, viewID, durableLockingID);
        }
        return NormalCDOLockOwner.create(sessionID, viewID);
    }

    public static CDOLockDelta createLockDelta(Object target, IRWLockManager.LockType type, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        return CDOLockDeltaImpl.create(target, type, oldOwner, newOwner);
    }

    public static CDOLockDelta createLockDelta(Object target) {
        return CDOLockDeltaImpl.createNull(target);
    }

    public static CDOLockChangeInfo createLockChangeInfo(CDOBranchPoint branchPoint, CDOLockOwner lockOwner, Collection<CDOLockDelta> lockDeltas, Collection<CDOLockState> lockStates) {
        return CDOLockUtil.createLockChangeInfo(branchPoint, lockOwner, lockDeltas, lockStates, false);
    }

    public static CDOLockChangeInfo createLockChangeInfo(CDOBranchPoint branchPoint, CDOLockOwner lockOwner, Collection<CDOLockDelta> lockDeltas, Collection<CDOLockState> lockStates, boolean isAdministrative) {
        return new CDOLockChangeInfoImpl(branchPoint, lockOwner, lockDeltas, lockStates, isAdministrative);
    }

    public static CDOLockChangeInfo createLockChangeInfo() {
        return new CDOLockChangeInfoImpl();
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return new CDOLockAreaImpl(durableLockingID, userID, branchPoint, readOnly, locks);
    }

    public static IDurableLockingManager.LockArea createLockArea(String durableLockingID) {
        return new CDOLockAreaImpl(durableLockingID);
    }

    public static String createDurableLockingID() {
        return CDOLockUtil.createDurableLockingID(32);
    }

    public static String createDurableLockingID(int bytes) {
        byte[] buffer = new byte[bytes];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(buffer);
        return HexUtil.bytesToHex((byte[])buffer);
    }

    public static List<CDOLockDelta> appendLockDelta(List<CDOLockDelta> deltas, Object target, IRWLockManager.LockType type, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        return CDOLockUtil.appendLockDelta(deltas, CDOLockUtil.createLockDelta(target, type, oldOwner, newOwner));
    }

    public static List<CDOLockDelta> appendLockDelta(List<CDOLockDelta> deltas, CDOLockDelta delta) {
        if (delta != null) {
            if (deltas == null) {
                deltas = new ArrayList<CDOLockDelta>(1);
            }
            deltas.add(delta);
        }
        return deltas;
    }

    public static CDOLockDelta[] toArray(List<CDOLockDelta> deltas) {
        if (ObjectUtil.isEmpty(deltas)) {
            return NO_LOCK_DELTAS;
        }
        return deltas.toArray(new CDOLockDelta[deltas.size()]);
    }

    @Deprecated
    public static CDOLockState copyLockState(CDOLockState lockState) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static CDOLockState copyLockState(CDOLockState lockState, Object lockedObject) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static CDOLockState createLockState(RWOLockManager.LockState<Object, ? extends CDOCommonView> lockState) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOLockOwner lockOwner, CDOBranch branch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] newLockStates) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static CDOLockChangeInfo createLockChangeInfo(long timestamp, CDOCommonView view, CDOBranch viewedBranch, CDOLockChangeInfo.Operation op, IRWLockManager.LockType lockType, CDOLockState[] newLockStates) {
        throw new UnsupportedOperationException();
    }
}

