/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateViewNode
extends DDLStatementNode {
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;
    private String qeText;
    private int checkOption;
    private ProviderInfo[] providerInfos;
    private ColumnInfo[] colInfos;
    private OrderByList orderByList;
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;

    CreateViewNode(TableName viewName, ResultColumnList resultColumns, ResultSetNode queryExpression, int checkOption, String qeText, OrderByList orderCols, ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause, ContextManager cm) throws StandardException {
        super(viewName, cm);
        this.resultColumns = resultColumns;
        this.queryExpression = queryExpression;
        this.checkOption = checkOption;
        this.qeText = qeText.trim();
        this.orderByList = orderCols;
        this.offset = offset;
        this.fetchFirst = fetchFirst;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.implicitCreateSchema = true;
    }

    @Override
    public String toString() {
        return super.toString() + "checkOption: " + this.checkOption + "\nqeText: " + this.qeText + "\n";
    }

    @Override
    String statementToString() {
        return "CREATE VIEW";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultColumns != null) {
            this.printLabel(depth, "resultColumns: ");
            this.resultColumns.treePrint(depth + 1);
        }
        this.printLabel(depth, "queryExpression: ");
        this.queryExpression.treePrint(depth + 1);
    }

    @Override
    public void bindStatement() throws StandardException {
        String duplicateColName;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, cc, this.getLanguageConnectionContext(), this.getOptimizerFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList qeRCL = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != qeRCL.visibleSize()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            qeRCL.copyResultColumnNames(this.resultColumns);
        }
        if ((duplicateColName = qeRCL.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", duplicateColName);
        }
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", String.valueOf(this.queryExpression.getResultColumns().size()), this.getRelativeName(), String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().visibleSize()];
        this.genColumnInfos(this.colInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext lcc, OptimizerFactory optimizerFactory, ResultSetNode queryExpr, ContextManager cm) throws StandardException {
        FromList fromList = new FromList(optimizerFactory.doJoinOrderOptimization(), cm);
        ProviderList prevAPL = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList apl = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(apl);
            compilerContext.pushCurrentPrivType(0);
            queryExpr = queryExpr.bindNonVTITables(dataDictionary, fromList);
            queryExpr = queryExpr.bindVTITables(fromList);
            queryExpr.bindExpressions(fromList);
            if (queryExpr instanceof SelectNode && queryExpr.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S", new Object[0]);
            }
            queryExpr.bindResultColumns(fromList);
            queryExpr.bindUntypedNullsToResultColumns(null);
        }
        finally {
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(prevAPL);
        }
        DependencyManager dm = dataDictionary.getDependencyManager();
        ProviderInfo[] provInfo = dm.getPersistentProviderInfos(apl);
        dm.clearColumnInfoInProviders(apl);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        return provInfo;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] colInfos) {
        ResultColumnList rcl = this.queryExpression.getResultColumns();
        for (int index = 0; index < colInfos.length; ++index) {
            ResultColumn rc = (ResultColumn)rcl.elementAt(index);
            if (rc.isGenerated()) {
                SanityManager.THROWASSERT("Encountered generated column in expected visible range at rcl[" + index + "]");
            }
            colInfos[index] = new ColumnInfo(rc.getName(), rc.getType(), null, null, null, null, null, 0, 0L, 0L, false, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.queryExpression != null) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(v);
        }
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getFetchFirst() {
        return this.fetchFirst;
    }

    public boolean hasJDBClimitClause() {
        return this.hasJDBClimitClause;
    }
}

