/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public class LifecycleMapping<K, V> {
    private final Map<K, V> map = new WeakHashMap();
    private final IListener lifecycleListener = new LifecycleEventAdapter(){

        @Override
        protected void onDeactivated(ILifecycle lifecycle) {
            ILifecycle key = lifecycle;
            LifecycleMapping.this.removeMapping(key);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getMapping(K lifecycle) {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.get(lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrAddMapping(K lifecycle, Supplier<V> valueSupplier) {
        Map<K, V> map = this.map;
        synchronized (map) {
            return (V)this.map.computeIfAbsent(lifecycle, k -> {
                if (lifecycle instanceof ILifecycle) {
                    ((ILifecycle)lifecycle).addListener(this.lifecycleListener);
                }
                return valueSupplier.get();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMapping(K lifecycle, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            block5: {
                if (this.map.putIfAbsent(lifecycle, value) != null) break block5;
                if (lifecycle instanceof ILifecycle) {
                    ((ILifecycle)lifecycle).addListener(this.lifecycleListener);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeMapping(K lifecycle) {
        Map<K, V> map = this.map;
        synchronized (map) {
            V value = this.map.remove(lifecycle);
            if (value != null && lifecycle instanceof ILifecycle) {
                ((ILifecycle)lifecycle).removeListener(this.lifecycleListener);
            }
            return value;
        }
    }
}

