/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.net4j.ITransportConfigAware;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.data.HugeData;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.PartialReadRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.concurrent.MonitoredThread;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.eclipse.spi.net4j.InternalChannel;
import org.eclipse.spi.net4j.InternalConnector;
import org.junit.Assert;

public class ChannelTest
extends AbstractConfigTest {
    private static final long TIMEOUT = 20000L;
    private static final int THREADS = 40;
    private List<TestSignalProtocol> protocols;

    public void testAllBufferSizes() throws Exception {
        this.disableConsole();
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        ChannelTest.assertActive((Object)protocol);
        short bufferCapacity = ((ITransportConfigAware)this.getConnector()).getConfig().getBufferProvider().getBufferCapacity();
        byte[] data = HugeData.getBytes();
        ChannelTest.assertEquals((boolean)true, (data.length > 2 * bufferCapacity ? 1 : 0) != 0);
        int i = 1;
        while (i < data.length) {
            byte[] dataToSend = new byte[i];
            System.arraycopy(data, 0, dataToSend, 0, i);
            byte[] result = (byte[])new ArrayRequest(protocol, dataToSend).send();
            ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(dataToSend, result));
            ++i;
        }
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
        this.enableConsole();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleThreadNoData() throws Exception {
        final AbstractOMTest.LatchTimeOuter timeOuter = new AbstractOMTest.LatchTimeOuter(4);
        DeactivationListener deactivationListener = new DeactivationListener(){

            @Override
            protected void onDeactivated(ILifecycle lifecycle) {
                super.onDeactivated(lifecycle);
                timeOuter.countDown();
            }
        };
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        protocol.addListener((IListener)deactivationListener);
        ChannelTest.assertActive((Object)protocol);
        IChannel channel = protocol.getChannel();
        channel.addListener((IListener)deactivationListener);
        ChannelTest.assertActive(channel);
        InternalConnector serverConnector = (InternalConnector)this.getAcceptor().getAcceptedConnectors()[0];
        Collection serverChannels = serverConnector.getChannels();
        ChannelTest.assertEquals((int)1, (int)serverChannels.size());
        IChannel serverChannel = (IChannel)serverChannels.iterator().next();
        serverChannel.addListener((IListener)deactivationListener);
        ChannelTest.assertActive(serverChannel);
        TestSignalProtocol serverProtocol = (TestSignalProtocol)serverChannel.getReceiveHandler();
        serverProtocol.addListener((IListener)deactivationListener);
        ChannelTest.assertActive((Object)serverProtocol);
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
        ChannelTest.assertInactive(channel);
        ChannelTest.assertInactive(serverChannel);
        ChannelTest.assertInactive((Object)serverProtocol);
        ChannelTest.assertEquals((int)0, (int)serverConnector.getChannels().size());
        timeOuter.assertNoTimeOut();
        Set<ILifecycle> deactivatedSet = deactivationListener.getDeactivatedSet();
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains(channel));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains((Object)protocol));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains(serverChannel));
        ChannelTest.assertEquals((boolean)true, (boolean)deactivatedSet.contains((Object)serverProtocol));
        List<TestSignalProtocol> list = this.protocols;
        synchronized (list) {
            ChannelTest.assertEquals((int)0, (int)this.protocols.size());
        }
    }

    public void testSingleThreadNoData100() throws Exception {
        this.disableConsole();
        int i = 0;
        while (i < 100) {
            ChannelTest.log(Thread.currentThread().getName() + ": " + i);
            this.testSingleThreadNoData();
            ++i;
        }
    }

    public void testSingleThreadTinyData() throws Exception {
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        ChannelTest.assertActive((Object)protocol);
        byte[] data = TinyData.getBytes();
        byte[] result = (byte[])new ArrayRequest(protocol, data).send();
        ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
    }

    public void testSingleThreadTinyData100() throws Exception {
        this.disableConsole();
        int i = 0;
        while (i < 100) {
            ChannelTest.log(Thread.currentThread().getName() + ": " + i);
            this.testSingleThreadTinyData();
            ++i;
        }
    }

    public void testSingleThreadHugeDataLong() throws Exception {
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        ChannelTest.assertActive((Object)protocol);
        byte[] data = HugeData.getBytes();
        int i = 0;
        while (i < 1000) {
            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
            ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
            ++i;
        }
        int SIGNALS = 10000;
        long start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 10000) {
            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
            Assert.assertArrayEquals((byte[])data, (byte[])result);
            ++i2;
        }
        long duration = System.currentTimeMillis() - start;
        ChannelTest.log("Millis for 10000 signals: " + duration);
        InternalChannel channel = (InternalChannel)protocol.getChannel();
        ChannelTest.log("Sent buffers: " + channel.getSentBuffers());
        ChannelTest.log("Received buffers: " + channel.getReceivedBuffers());
        protocol.close();
        ChannelTest.assertInactive((Object)protocol);
    }

    public void testMultiThreadNoData() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 100) {
                        ChannelTest.log(Thread.currentThread().getName() + ": " + i);
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        this.heartBeat();
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    public void testMultiThreadTinyData() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 100) {
                        ChannelTest.log(Thread.currentThread().getName() + ": " + i);
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        this.heartBeat();
                        byte[] data = TinyData.getBytes();
                        byte[] result = (byte[])new ArrayRequest(protocol, data).send();
                        ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
                        this.heartBeat();
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        this.heartBeat();
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    public void testMultiThreadDataLoop() throws Exception {
        MonitoredThread.MultiThreadMonitor threadMonitor = new MonitoredThread.MultiThreadMonitor(20000000L, 10L);
        int i = 0;
        while (i < 40) {
            threadMonitor.addThread(new MonitoredThread("TEST-THREAD-" + i, (MonitoredThread.ThreadMonitor)threadMonitor){

                protected void doRun() throws Exception {
                    int i = 0;
                    while (i < 10) {
                        long start = System.currentTimeMillis();
                        TestSignalProtocol protocol = ChannelTest.this.openTestSignalProtocol();
                        ChannelTest.assertActive((Object)protocol);
                        int j = 0;
                        while (j < 50) {
                            byte[] data = TinyData.getBytes();
                            byte[] result = (byte[])new ArrayRequest(protocol, data).send();
                            ChannelTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
                            this.heartBeat();
                            ++j;
                        }
                        protocol.close();
                        ChannelTest.assertInactive((Object)protocol);
                        long stop = System.currentTimeMillis();
                        ChannelTest.log(Thread.currentThread().getName() + ": " + i + " (" + (stop - start) + ")");
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.disableConsole();
        threadMonitor.run();
        this.enableConsole();
    }

    public void testStreamFitsInOneBuffer() throws Exception {
        final CountDownLatch signalFinished = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        this.acceptorContainer.registerFactory((IFactory)new TestSignalProtocol.Factory(){

            @Override
            public TestSignalProtocol create(String description) throws ProductCreationException {
                TestSignalProtocol protocol = new TestSignalProtocol(){
                    private int receivedBuffers;

                    public void handleBuffer(IBuffer buffer) {
                        System.out.println("Received buffer " + this.receivedBuffers + " --> eos=" + buffer.isEOS());
                        if (this.receivedBuffers++ == 1) {
                            ChannelTest.await(signalFinished);
                        }
                        try {
                            super.handleBuffer(buffer);
                        }
                        catch (BufferUnderflowException ex) {
                            ex.printStackTrace();
                            exception.set(ex);
                        }
                    }
                };
                protocol.setVersion(this.version);
                return protocol;
            }
        });
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        InternalConnector serverConnector = (InternalConnector)this.getAcceptor().getAcceptedConnectors()[0];
        IChannel serverChannel = (IChannel)serverConnector.getChannels().iterator().next();
        TestSignalProtocol serverProtocol = (TestSignalProtocol)serverChannel.getReceiveHandler();
        serverProtocol.addListener(event -> {
            if (event instanceof SignalFinishedEvent) {
                signalFinished.countDown();
            }
        });
        byte[] hugeData = HugeData.getBytes();
        int headerSize = 4;
        headerSize += 4;
        headerSize += 2;
        byte[] data = new byte[4096 - (headerSize += 4)];
        System.arraycopy(hugeData, 0, data, 0, data.length);
        new ArrayRequest(protocol, data, true).send();
        ChannelTest.assertSame(null, exception.get());
    }

    public void testPartialRead() throws Exception {
        final CountDownLatch signalFinished = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        this.acceptorContainer.registerFactory((IFactory)new TestSignalProtocol.Factory(){

            @Override
            public TestSignalProtocol create(String description) throws ProductCreationException {
                TestSignalProtocol protocol = new TestSignalProtocol(){
                    private int receivedBuffers;

                    public void handleBuffer(IBuffer buffer) {
                        System.out.println("Received buffer " + this.receivedBuffers + " --> eos=" + buffer.isEOS());
                        if (this.receivedBuffers++ == 1) {
                            ChannelTest.await(signalFinished);
                        }
                        try {
                            super.handleBuffer(buffer);
                        }
                        catch (SignalProtocol.InvalidSignalIDException ex) {
                            ex.printStackTrace();
                            exception.set(ex);
                        }
                    }
                };
                protocol.setVersion(this.version);
                return protocol;
            }
        });
        TestSignalProtocol protocol = this.openTestSignalProtocol();
        InternalConnector serverConnector = (InternalConnector)this.getAcceptor().getAcceptedConnectors()[0];
        IChannel serverChannel = (IChannel)serverConnector.getChannels().iterator().next();
        TestSignalProtocol serverProtocol = (TestSignalProtocol)serverChannel.getReceiveHandler();
        serverProtocol.addListener(event -> {
            if (event instanceof SignalFinishedEvent) {
                signalFinished.countDown();
            }
        });
        new PartialReadRequest(protocol).send();
        ChannelTest.assertSame(null, exception.get());
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.startTransport();
        this.getConnector().setOpenChannelTimeout(20000L);
        this.protocols = new ArrayList<TestSignalProtocol>();
    }

    @Override
    protected void doTearDown() throws Exception {
        try {
            if (this.protocols != null) {
                for (TestSignalProtocol protocol : new ArrayList<TestSignalProtocol>(this.protocols)) {
                    protocol.close();
                }
                this.protocols = null;
            }
            if (this.connector != null) {
                this.connector.close();
                this.connector = null;
            }
        }
        finally {
            super.doTearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestSignalProtocol openTestSignalProtocol() {
        IConnector connector = this.getConnector();
        final TestSignalProtocol protocol = new TestSignalProtocol(connector);
        List<TestSignalProtocol> list = this.protocols;
        synchronized (list) {
            this.protocols.add(protocol);
            protocol.getChannel().addListener((IListener)new LifecycleEventAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onDeactivated(ILifecycle lifecycle) {
                    List<TestSignalProtocol> list = ChannelTest.this.protocols;
                    synchronized (list) {
                        IChannel channel = protocol.getChannel();
                        if (channel != null) {
                            channel.removeListener((IListener)this);
                        }
                        boolean removed = ChannelTest.this.protocols.remove((Object)protocol);
                        ChannelTest.assertEquals((boolean)true, (boolean)removed);
                    }
                }
            });
        }
        return protocol;
    }

    private static void log(String message) {
        IOUtil.OUT().println(message);
    }

    private static class DeactivationListener
    extends LifecycleEventAdapter {
        private Set<ILifecycle> deactivatedSet = new HashSet<ILifecycle>();

        public Set<ILifecycle> getDeactivatedSet() {
            return this.deactivatedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDeactivated(ILifecycle lifecycle) {
            Set<ILifecycle> set = this.deactivatedSet;
            synchronized (set) {
                this.deactivatedSet.add(lifecycle);
                this.deactivatedSet.notifyAll();
            }
        }
    }
}

