/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.ref.Interner;
import org.eclipse.net4j.util.security.SecurityUtil;

public class LDAPUserAuthenticator
extends IRepositoryProtector.UserAuthenticator
implements Entity.Store.Provider {
    public static final String SCOPE_OBJECT = "object";
    public static final String SCOPE_ONELEVEL = "onelevel";
    public static final String SCOPE_SUBTREE = "subtree";
    public static final String FILTER_ANY = "(objectClass=*)";
    private final Tree config;
    private final Map<String, EnvironmentConfig> environmentConfigs = new HashMap<String, EnvironmentConfig>();
    private final Map<LDAPDN, LDAPEntry> entries = new WeakHashMap<LDAPDN, LDAPEntry>();
    private final Entity.Store entityStore;

    public LDAPUserAuthenticator(Tree config) {
        this.config = config;
        Tree tree = config.child("entityStore");
        this.entityStore = tree == null ? null : new LDAPEntityStore(tree);
    }

    @Override
    public Class<? extends IRepositoryProtector.UserInfo> getUserInfoClass() {
        return LDAPUserInfo.class;
    }

    public Entity.Store getEntityStore() {
        return this.entityStore;
    }

    @Override
    public IRepositoryProtector.UserInfo authenticateUser(String userID, char[] password) {
        String userPW = SecurityUtil.toString((char[])password);
        if (!StringUtil.isEmpty((String)userPW)) {
            try {
                LDAPEntry userEntry = this.searchUser(userID);
                if (userEntry != null) {
                    return this.loginUser(userID, userPW, userEntry);
                }
            }
            catch (AuthenticationException userEntry) {
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        return null;
    }

    protected LDAPEntry searchUser(String userID) throws NamingException {
        Tree searchConfig = this.config.child("searchUser");
        if (searchConfig != null) {
            HashMap<String, String> stringSubstitutions = new HashMap<String, String>();
            stringSubstitutions.put(this.stringSubstitutionKey("USER_ID"), userID);
            List<LDAPEntry> entries = this.ldapSearch(searchConfig, stringSubstitutions, null);
            if (entries.size() > 1) {
                throw new IllegalStateException("User " + userID + " has multiple LDAP entries: " + entries);
            }
            if (!entries.isEmpty()) {
                return entries.get(0);
            }
        }
        return null;
    }

    protected LDAPUserInfo loginUser(String userID, String userPW, LDAPEntry userEntry) throws NamingException {
        HashMap<String, String> stringSubstitutions = new HashMap<String, String>();
        stringSubstitutions.put(this.stringSubstitutionKey("USER_ID"), userID);
        stringSubstitutions.put(this.stringSubstitutionKey("USER_PW"), userPW);
        this.addStringSubstitutions(stringSubstitutions, "USER_", userEntry);
        Tree loginUserConfig = this.config.child("loginUser");
        Map attributes = loginUserConfig.attributes();
        String environmentID = this.expandValue((String)attributes.get("environment"), stringSubstitutions);
        Hashtable<String, String> environment = this.createEnvironment(environmentID, stringSubstitutions);
        return LDAPUserAuthenticator.ldapCall(environment, context -> this.createUserInfo(userID, userEntry, loginUserConfig, context));
    }

    protected LDAPUserInfo createUserInfo(String userID, LDAPEntry userEntry, Tree config, DirContext context) throws NamingException {
        List<LDAPEntry> entries;
        Tree searchGroupsConfig;
        List<LDAPEntry> entries2;
        HashSet<LDAPDN> groupDNs = new HashSet<LDAPDN>();
        Tree extractGroupsConfig = config.child("extractGroups");
        if (extractGroupsConfig != null && (entries2 = this.extractGroups(userID, userEntry, extractGroupsConfig, context)) != null) {
            entries2.forEach(entry -> {
                boolean bl = groupDNs.add(entry.DN());
            });
        }
        if ((searchGroupsConfig = config.child("searchGroups")) != null && (entries = this.searchGroups(userID, userEntry, searchGroupsConfig, context)) != null) {
            entries.forEach(entry -> {
                boolean bl = groupDNs.add(entry.DN());
            });
        }
        return new LDAPUserInfo(userID, userEntry.DN(), groupDNs);
    }

    protected List<LDAPEntry> extractGroups(String userID, LDAPEntry userEntry, Tree config, DirContext context) throws NamingException {
        return null;
    }

    protected List<LDAPEntry> searchGroups(String userID, LDAPEntry userEntry, Tree config, DirContext context) throws NamingException {
        HashMap<String, String> stringSubstitutions = new HashMap<String, String>();
        stringSubstitutions.put(this.stringSubstitutionKey("USER_ID"), userID);
        this.addStringSubstitutions(stringSubstitutions, "USER_", userEntry);
        return this.ldapSearch(config, stringSubstitutions, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<LDAPDN, LDAPEntry> ldapEntries(Collection<LDAPDN> dns) {
        HashMap<LDAPDN, LDAPEntry> result = new HashMap<LDAPDN, LDAPEntry>();
        Map<LDAPDN, LDAPEntry> map = this.entries;
        synchronized (map) {
            for (LDAPDN dn : dns) {
                LDAPEntry entry = this.entries.get(dn);
                if (entry == null) continue;
                result.put(dn, entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LDAPEntry ldapEntry(LDAPDN dn) {
        Map<LDAPDN, LDAPEntry> map = this.entries;
        synchronized (map) {
            return this.entries.get(dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final LDAPEntry ldapEntry(LDAPDN dn, String rdn, Attributes attributes, Object object) {
        LDAPEntry entry = new LDAPEntry(dn, rdn, attributes, object);
        Map<LDAPDN, LDAPEntry> map = this.entries;
        synchronized (map) {
            this.entries.put(dn, entry);
        }
        return entry;
    }

    protected final LDAPEntry ldapEntry(SearchResult result) {
        LDAPDN dn = LDAPDN.create(result.getNameInNamespace());
        String rdn = result.getName();
        Attributes attributes = result.getAttributes();
        Object object = result.getObject();
        return this.ldapEntry(dn, rdn, attributes, object);
    }

    protected final List<LDAPEntry> ldapSearch(Tree searchConfig, Map<String, String> stringSubstitutions, DirContext outerContext) throws NamingException {
        Map map = searchConfig.attributes();
        String start = this.expandValue((String)map.get("start"), stringSubstitutions);
        int scope = LDAPUserAuthenticator.parseSearchScope(this.expandValue((String)map.get("scope"), stringSubstitutions));
        String filter = LDAPUserAuthenticator.parseFilter(this.expandValue((String)map.get("filter"), stringSubstitutions));
        long countLimit = LDAPUserAuthenticator.parseLong(this.expandValue((String)map.get("countLimit"), stringSubstitutions), 0L);
        int timeLimit = LDAPUserAuthenticator.parseInt(this.expandValue((String)map.get("timeLimit"), stringSubstitutions), 0);
        String[] returnAttributes = LDAPUserAuthenticator.parseStrings(this.expandValue((String)map.get("returnAttributes"), stringSubstitutions), new String[0]);
        boolean returnObject = LDAPUserAuthenticator.parseBoolean(this.expandValue((String)map.get("returnObject"), stringSubstitutions), false);
        LDAPCallable<List> callable = context -> {
            ArrayList<LDAPEntry> entries = new ArrayList<LDAPEntry>();
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(scope);
            searchControls.setCountLimit(countLimit);
            searchControls.setTimeLimit(timeLimit);
            searchControls.setReturningAttributes(returnAttributes);
            searchControls.setReturningObjFlag(returnObject);
            NamingEnumeration<SearchResult> results = context.search(start, filter, searchControls);
            while (results.hasMore()) {
                SearchResult result = results.next();
                LDAPEntry entry = this.ldapEntry(result);
                entries.add(entry);
            }
            return entries;
        };
        String environmentID = this.expandValue((String)map.get("environment"), stringSubstitutions);
        if (environmentID == null && outerContext != null) {
            return callable.call(outerContext);
        }
        Hashtable<String, String> environment = this.createEnvironment(environmentID, stringSubstitutions);
        return LDAPUserAuthenticator.ldapCall(environment, callable);
    }

    protected Hashtable<String, String> createEnvironment(String id, Map<String, String> stringSubstitutions) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        HashSet<String> visited = new HashSet<String>();
        this.fillEnvironment(id, stringSubstitutions, environment, visited);
        return environment;
    }

    protected void fillEnvironment(String id, Map<String, String> stringSubstitutions, Hashtable<String, String> environment, Set<String> visited) {
        if (!visited.add(id)) {
            throw new IllegalStateException("Environment cycle detected: " + id);
        }
        EnvironmentConfig environmentConfig = this.environmentConfigs.get(id);
        if (environmentConfig == null) {
            throw new IllegalStateException("Environment not found: " + id);
        }
        List<String> inherits = environmentConfig.inherits();
        for (String inherit : inherits) {
            this.fillEnvironment(inherit, stringSubstitutions, environment, visited);
        }
        Map<String, String> properties = environmentConfig.properties();
        properties.forEach((name, value) -> {
            String string = environment.put((String)name, this.expandValue((String)value, stringSubstitutions));
        });
    }

    protected String expandValue(String value, Map<String, String> stringSubstitutions) {
        if (value == null) {
            return null;
        }
        IManagedContainer container = this.getContainer();
        return RepositoryConfigurator.expandValue(value, stringSubstitutions, container);
    }

    protected String stringSubstitutionKey(String str) {
        return String.valueOf('$') + str + '$';
    }

    protected void addStringSubstitutions(Map<String, String> stringSubstitutions, String prefix, LDAPEntry entry) throws NamingException {
        prefix = StringUtil.safe((String)prefix);
        stringSubstitutions.put(this.stringSubstitutionKey(String.valueOf(prefix) + "DN"), entry.DN().toString());
        stringSubstitutions.put(this.stringSubstitutionKey(String.valueOf(prefix) + "RDN"), entry.RDN());
        stringSubstitutions.put(this.stringSubstitutionKey(String.valueOf(prefix) + "PDN"), entry.PDN());
        Attributes attributes = entry.attributes();
        if (attributes != null) {
            NamingEnumeration<? extends Attribute> attrIt = attributes.getAll();
            while (attrIt.hasMore()) {
                Attribute attribute = attrIt.next();
                String key = this.stringSubstitutionKey(String.valueOf(prefix) + "ATTR_" + attribute.getID());
                int size = attribute.size();
                if (size == 1) {
                    Object value = attribute.get();
                    if (!(value instanceof String)) continue;
                    stringSubstitutions.put(key, (String)value);
                    continue;
                }
                if (size <= 1) continue;
                StringJoiner joiner = new StringJoiner(", ");
                NamingEnumeration<?> valueIt = attribute.getAll();
                while (valueIt.hasMore()) {
                    Object value = valueIt.next();
                    if (!(value instanceof String)) continue;
                    joiner.add((String)value);
                }
                if (joiner.length() == 0) continue;
                stringSubstitutions.put(key, "{" + joiner + "}");
            }
        }
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.config, "config");
    }

    protected void doActivate() throws Exception {
        this.config.children("environment", env -> {
            String id = env.attribute("id");
            String inherits = env.attribute("inherits");
            Map properties = env.properties();
            this.environmentConfigs.put(id, new EnvironmentConfig(id, inherits, properties));
        });
    }

    protected void doDeactivate() throws Exception {
        this.environmentConfigs.clear();
        this.entries.clear();
    }

    protected static <T> T ldapCall(Hashtable<String, String> environment, LDAPCallable<T> callable) throws NamingException {
        try (InitialDirContext context = new InitialDirContext(environment);){
            T t = callable.call(context);
            return t;
        }
    }

    protected static boolean parseBoolean(String str, boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(str);
    }

    protected static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    protected static long parseLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return Long.parseLong(str);
    }

    protected static List<String> parseStrings(String str, List<String> defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if (str.length() != 0) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken().trim();
                if (StringUtil.isEmpty((String)id)) continue;
                result.add(id);
            }
            if (!result.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList(result));
            }
        }
        return Collections.emptyList();
    }

    protected static String[] parseStrings(String str, String[] defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        List<String> defaultList = defaultValue == null ? null : Arrays.asList(defaultValue);
        List<String> list = LDAPUserAuthenticator.parseStrings(str, defaultList);
        return list.toArray(new String[list.size()]);
    }

    protected static int parseSearchScope(String str) {
        if (str == null || str.equals(SCOPE_SUBTREE)) {
            return 2;
        }
        if (str.equals(SCOPE_ONELEVEL)) {
            return 1;
        }
        if (str.equals(SCOPE_OBJECT)) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal search scope: " + str);
    }

    protected static String parseFilter(String str) {
        return str == null ? FILTER_ANY : str;
    }

    public static final class EnvironmentConfig {
        private final String id;
        private final List<String> inherits;
        private final Map<String, String> properties;

        public EnvironmentConfig(String id, String inherits, Map<String, String> properties) {
            this.id = EnvironmentConfig.checkID(id);
            this.inherits = LDAPUserAuthenticator.parseStrings(inherits, Collections.emptyList());
            this.properties = Collections.unmodifiableMap(properties);
        }

        public final String id() {
            return this.id;
        }

        public final List<String> inherits() {
            return this.inherits;
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.inherits, this.properties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnvironmentConfig other = (EnvironmentConfig)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.inherits, other.inherits) && Objects.equals(this.properties, other.properties);
        }

        public String toString() {
            return "EnvironmentConfig[" + this.id + "]";
        }

        private static String checkID(String str) throws IllegalArgumentException {
            if (!StringUtil.isEmpty((String)str)) {
                if (str.indexOf(44) != -1) {
                    throw new IllegalArgumentException("Illegal environment ID: " + str);
                }
                return str.trim();
            }
            return null;
        }
    }

    @FunctionalInterface
    protected static interface LDAPCallable<T> {
        public T call(DirContext var1) throws NamingException;
    }

    public static final class LDAPDN {
        private static final DNInterner INTERNER = new DNInterner();
        private final String value;

        private LDAPDN(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return LDAPDN.getHashCode(this.value);
        }

        private static int getHashCode(String value) {
            return Objects.hashCode(value);
        }

        public static LDAPDN create(String value) {
            return value == null ? null : INTERNER.intern(value);
        }

        private static final class DNInterner
        extends Interner<LDAPDN> {
            private DNInterner() {
            }

            public synchronized LDAPDN intern(String value) {
                int hashCode = LDAPDN.getHashCode(value);
                Interner.Entry entry = this.getEntry(hashCode);
                while (entry != null) {
                    LDAPDN dn = (LDAPDN)entry.get();
                    if (dn != null && Objects.equals(dn.value, value)) {
                        return dn;
                    }
                    entry = entry.getNextEntry();
                }
                LDAPDN dn = new LDAPDN(value);
                this.addEntry(this.createEntry(dn, hashCode));
                return dn;
            }

            protected int hashCode(LDAPDN id) {
                return LDAPDN.getHashCode(id.value);
            }
        }
    }

    private final class LDAPEntityStore
    extends Entity.SingleNamespaceComputer {
        private final boolean exposeUserIDs;

        public LDAPEntityStore(Tree config) {
            super("cdo/user/info");
            this.exposeUserIDs = config.attribute("exposeUserIDs", false);
        }

        protected Collection<String> computeNames() {
            return Collections.emptySet();
        }

        protected Entity computeEntity(String name) {
            LDAPEntry entry;
            LDAPUserInfo userInfo = (LDAPUserInfo)LDAPUserAuthenticator.this.getRepositoryProtector().getUserInfo(name);
            if (userInfo != null && (entry = LDAPUserAuthenticator.this.ldapEntry(userInfo.userDN())) != null) {
                Attributes attributes = entry.attributes();
                Entity.Builder builder = this.entityBuilder(name);
                String[] stringArray = CDOProtocolConstants.USER_INFO_PROPERTIES;
                int n = CDOProtocolConstants.USER_INFO_PROPERTIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String propertyName = stringArray[n2];
                    Attribute attribute = attributes.get(propertyName);
                    if (attribute != null) {
                        builder.property(propertyName, attribute.toString());
                    }
                    ++n2;
                }
                return builder.build();
            }
            return null;
        }
    }

    public static final class LDAPEntry {
        private final LDAPDN dn;
        private final String rdn;
        private final Attributes attributes;
        private final Object object;

        private LDAPEntry(LDAPDN dn, String rdn, Attributes attributes, Object object) {
            this.dn = Objects.requireNonNull(dn);
            this.rdn = rdn;
            this.attributes = attributes;
            this.object = object;
        }

        public LDAPDN DN() {
            return this.dn;
        }

        public String RDN() {
            return this.rdn;
        }

        public String PDN() {
            if (this.rdn == null) {
                return null;
            }
            String dn = this.dn.toString();
            String parentDN = dn.substring(this.rdn.length()).trim();
            if (parentDN.length() != 0 && parentDN.charAt(0) == ',') {
                parentDN = dn.substring(1).trim();
            }
            return parentDN;
        }

        public Attributes attributes() {
            return this.attributes;
        }

        public Object object() {
            return this.object;
        }

        public int hashCode() {
            return this.dn.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LDAPEntry other = (LDAPEntry)obj;
            return this.dn == other.dn;
        }

        public String toString() {
            return "LDAPEntry[" + this.dn + "]";
        }
    }

    public static class LDAPUserInfo
    extends IRepositoryProtector.UserInfo {
        private final LDAPDN userDN;
        private final Set<LDAPDN> groupDNs;

        public LDAPUserInfo(String userID, LDAPDN userDN, Set<LDAPDN> groupDNs) {
            super(Objects.requireNonNull(userID));
            this.userDN = Objects.requireNonNull(userDN);
            this.groupDNs = ObjectUtil.isEmpty(groupDNs) ? Collections.emptySet() : Collections.unmodifiableSet(groupDNs);
        }

        public LDAPUserInfo(String userID, LDAPDN userEntry) {
            this(userID, userEntry, null);
        }

        public final LDAPDN userDN() {
            return this.userDN;
        }

        public Set<LDAPDN> groupDNs() {
            return this.groupDNs;
        }

        public boolean groupMember(LDAPDN groupDN) {
            return this.groupDNs.contains(groupDN);
        }

        @Override
        protected boolean isStructurallyEqual(IRepositoryProtector.UserInfo userInfo) {
            LDAPUserInfo other = (LDAPUserInfo)userInfo;
            return this.userDN == other.userDN && this.groupDNs.equals(other.groupDNs());
        }
    }
}

