/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import org.eclipse.net4j.ITransportConfig;
import org.eclipse.net4j.TransportInjector;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tests.bundle.OM;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.config.Net4jTestSuite;
import org.eclipse.net4j.tests.config.TestConfig;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.ChallengeNegotiator;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.ResponseNegotiator;
import org.eclipse.net4j.util.security.UserManager;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

@Net4jTestSuite.ExcludedConfig(value={TestConfig.JVM.class})
public class NegotiationTest
extends AbstractConfigTest {
    private static final String USER_ID = "stepper";
    private static final String INVALID_USER_ID = "invalid";
    private static final char[] PASSWORD = "eike2008".toCharArray();
    private static final char[] INVALID_PASSWORD = "invalid".toCharArray();
    private static final PasswordCredentials CREDENTIALS = new PasswordCredentials("stepper", PASSWORD);

    public void testNegotiationSuccess() throws Exception {
        this.acceptorContainer.addPostProcessor((IElementProcessor)new AcceptorNegotiatorInjector(USER_ID, PASSWORD));
        this.connectorContainer.addPostProcessor((IElementProcessor)new ConnectorNegotiatorInjector((IPasswordCredentials)CREDENTIALS));
        int i = 0;
        while (i < 5) {
            IOUtil.OUT().println(" RUN = " + i);
            IAcceptor acceptor = this.getAcceptor();
            IConnector connector = this.getConnector();
            connector.waitForConnection(15000L);
            IChannel clientChannel = connector.openChannel();
            NegotiationTest.assertEquals((String)USER_ID, (String)clientChannel.getUserID());
            IConnector serverConnector = ((IConnector[])acceptor.getElements())[0];
            IChannel serverChannel = ((IChannel[])serverConnector.getElements())[0];
            NegotiationTest.assertEquals((String)USER_ID, (String)serverChannel.getUserID());
            this.stopTransport();
            NegotiationTest.sleep(1000L);
            ++i;
        }
    }

    public void testInvalidUser() throws Exception {
        this.acceptorContainer.addPostProcessor((IElementProcessor)new AcceptorNegotiatorInjector(INVALID_USER_ID, PASSWORD));
        this.connectorContainer.addPostProcessor((IElementProcessor)new ConnectorNegotiatorInjector((IPasswordCredentials)CREDENTIALS));
        this.getAcceptor();
        IConnector connector = this.getConnector(false);
        try {
            connector.connectAsync();
            connector.waitForConnection(5000L);
            NegotiationTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            NegotiationTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof NegotiationException));
        }
    }

    public void testInvalidPassword() throws Exception {
        this.acceptorContainer.addPostProcessor((IElementProcessor)new AcceptorNegotiatorInjector(USER_ID, INVALID_PASSWORD));
        this.connectorContainer.addPostProcessor((IElementProcessor)new ConnectorNegotiatorInjector((IPasswordCredentials)CREDENTIALS));
        this.getAcceptor();
        IConnector connector = this.getConnector(false);
        try {
            connector.connectAsync();
            connector.waitForConnection(5000L);
            NegotiationTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            NegotiationTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof NegotiationException));
        }
    }

    public void testNoNegotiator() throws Exception {
        this.getAcceptor();
        Connector connector = (Connector)this.getConnector(false);
        connector.setUserID("SHOULD_FAIL_LATER");
        try {
            connector.connect();
            NegotiationTest.fail((String)"ConnectorException expected");
        }
        catch (ConnectorException ex) {
            OM.LOG.info("Expected ConnectorException:", (Throwable)ex);
            NegotiationTest.assertEquals((boolean)true, (boolean)(ex.getCause() instanceof IllegalStateException));
        }
    }

    public void testNegotiatorTooLate() throws Exception {
        this.getAcceptor();
        Connector connector = (Connector)this.getConnector();
        try {
            connector.getConfig().setNegotiator((INegotiator)new ResponseNegotiator());
            NegotiationTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            OM.LOG.info("Expected IllegalStateException:", (Throwable)ex);
        }
    }

    public static final class AcceptorNegotiatorInjector
    extends TransportInjector {
        private Randomizer randomizer = new Randomizer();
        private UserManager userManager;
        private ChallengeNegotiator challengeNegotiator;

        public AcceptorNegotiatorInjector(String userID, char[] password) {
            this.randomizer.activate();
            this.userManager = new UserManager();
            this.userManager.activate();
            this.userManager.addUser(userID, password);
            this.challengeNegotiator = new ChallengeNegotiator();
            this.challengeNegotiator.setRandomizer((IRandomizer)this.randomizer);
            this.challengeNegotiator.setUserManager((IUserManager)this.userManager);
            this.challengeNegotiator.activate();
        }

        protected void processAcceptor(IManagedContainer container, String factoryType, String description, InternalAcceptor acceptor) {
            ITransportConfig config = acceptor.getConfig();
            if (config.getNegotiator() == null) {
                config.setNegotiator((INegotiator)this.challengeNegotiator);
            }
        }

        protected void processConnector(IManagedContainer container, String factoryType, String description, InternalConnector connector) {
        }
    }

    public static final class ConnectorNegotiatorInjector
    extends TransportInjector {
        private PasswordCredentialsProvider credentialsProvider;
        private ResponseNegotiator responseNegotiator;

        public ConnectorNegotiatorInjector(IPasswordCredentials credentials) {
            this.credentialsProvider = new PasswordCredentialsProvider(credentials);
            LifecycleUtil.activate((Object)this.credentialsProvider);
            this.responseNegotiator = new ResponseNegotiator();
            this.responseNegotiator.setCredentialsProvider((IPasswordCredentialsProvider)this.credentialsProvider);
            this.responseNegotiator.activate();
        }

        protected void processAcceptor(IManagedContainer container, String factoryType, String description, InternalAcceptor acceptor) {
        }

        protected void processConnector(IManagedContainer container, String factoryType, String description, InternalConnector connector) {
            ITransportConfig config = connector.getConfig();
            if (config.getNegotiator() == null) {
                config.setNegotiator((INegotiator)this.responseNegotiator);
            }
        }
    }
}

