/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import java.util.function.Consumer;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewStatus;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.fsm.FiniteStateMachine;
import org.eclipse.net4j.util.fsm.ITransition;

public abstract class ReviewStatemachine<REVIEW extends Review>
extends FiniteStateMachine<ReviewStatus, ReviewEvent, REVIEW> {
    public static final String PROP_SUBMITTING = "org.eclipse.emf.cdo.lm.submitting";
    private static final int COMMIT_RETRIES = 10;
    private final boolean client;
    private final boolean dropReviews;

    private ReviewStatemachine(boolean client, boolean dropReviews) {
        super(ReviewStatus.class, ReviewEvent.class);
        this.client = client;
        this.dropReviews = dropReviews;
        this.INIT(ReviewStatus.NEW, ReviewEvent.CommitInSource, new CommitInSourceTransition());
        this.INIT(ReviewStatus.NEW, ReviewEvent.CommitInTarget, new CommitInTargetTransition());
        this.INIT(ReviewStatus.NEW, ReviewEvent.MergeFromSource, IGNORE);
        this.INIT(ReviewStatus.NEW, ReviewEvent.RebaseToTarget, IGNORE);
        this.INIT(ReviewStatus.NEW, ReviewEvent.Submit, new SubmitTransition());
        this.INIT(ReviewStatus.NEW, ReviewEvent.Abandon, new AbandonTransition());
        this.INIT(ReviewStatus.NEW, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.NEW, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.NEW, ReviewEvent.Delete, new DeleteTranstion());
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.CommitInTarget, new CommitInTargetTransition());
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.MergeFromSource, new MergeFromSourceTransition());
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.RebaseToTarget, IGNORE);
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.Submit, new SubmitTransition());
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.Abandon, new AbandonTransition());
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.SOURCE_OUTDATED, ReviewEvent.Delete, new DeleteTranstion());
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.CommitInSource, (ITransition<ReviewStatus, ReviewEvent, REVIEW, Object>)(dropReviews ? IGNORE : new CommitInSourceTransition()));
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.MergeFromSource, IGNORE);
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.RebaseToTarget, new RebaseToTargetTransition());
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.Abandon, new AbandonTransition());
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.TARGET_OUTDATED, ReviewEvent.Delete, new DeleteTranstion());
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.MergeFromSource, new MergeFromSourceTransition());
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.RebaseToTarget, new RebaseToTargetTransition());
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.Abandon, new AbandonTransition());
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.OUTDATED, ReviewEvent.Delete, new DeleteTranstion());
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.MergeFromSource, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.RebaseToTarget, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.Abandon, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.SUBMITTED, ReviewEvent.Delete, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.MergeFromSource, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.RebaseToTarget, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.Abandon, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.Restore, new RestoreTransition());
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.ABANDONED, ReviewEvent.Delete, new DeleteTranstion());
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.MergeFromSource, FAIL);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.RebaseToTarget, FAIL);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.Abandon, FAIL);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.Finish, new RestoreFinishTransition());
        this.INIT(ReviewStatus.RESTORING, ReviewEvent.Delete, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.CommitInSource, IGNORE);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.CommitInTarget, IGNORE);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.MergeFromSource, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.RebaseToTarget, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.Submit, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.Abandon, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.Restore, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.Finish, FAIL);
        this.INIT(ReviewStatus.DELETED, ReviewEvent.Delete, FAIL);
    }

    protected final ReviewStatus getState(REVIEW review) {
        return review.getStatus();
    }

    protected final void setState(REVIEW review, ReviewStatus status) {
        review.setStatus(status);
    }

    protected abstract void handleCommitInSource(REVIEW var1);

    protected abstract void handleCommitInTarget(REVIEW var1);

    protected abstract void handleMergeFromSource(REVIEW var1, MergeFromSourceResult var2);

    protected abstract void handleRebaseToTarget(REVIEW var1, RebaseToTargetResult var2);

    protected abstract void handleSubmit(REVIEW var1, FixedBaseline var2);

    protected abstract void handleAbandon(REVIEW var1);

    protected abstract void handleRestore(REVIEW var1);

    protected abstract ReviewStatus handleRestoreFinish(REVIEW var1);

    protected abstract void handleDelete(REVIEW var1);

    protected final void setCommitComment(CDOObject object, String comment) {
        CDOTransaction transaction = (CDOTransaction)object.cdoView();
        transaction.setCommitComment(comment);
    }

    private void INIT(ReviewStatus status, ReviewEvent event, ITransition<ReviewStatus, ReviewEvent, REVIEW, Object> transition) {
        if (event.isClient() != this.client) {
            transition = FAIL;
        } else if (this.dropReviews && !event.isDrop()) {
            transition = IGNORE;
        } else if (!this.dropReviews && !event.isDelivery()) {
            transition = IGNORE;
        }
        this.init(status, event, transition);
    }

    public static <REVIEW extends Review> CDOCommitInfo modify(REVIEW review, Consumer<REVIEW> modifier) {
        CDOSession session = review.cdoView().getSession();
        ConcurrentAccessException[] exception = new ConcurrentAccessException[1];
        CDOCommitInfo[] result = new CDOCommitInfo[1];
        int i = 0;
        while (i <= 10) {
            exception[0] = null;
            try (CDOTransaction transaction = session.openTransaction();){
                transaction.sync().run(() -> {
                    Review transactionalReview = (Review)transaction.getObject((EObject)review);
                    modifier.accept(transactionalReview);
                    if (!transaction.isDirty()) {
                        return;
                    }
                    try {
                        cDOCommitInfoArray[0] = transaction.commit();
                        concurrentAccessExceptionArray[0] = null;
                    }
                    catch (ConcurrentAccessException ex) {
                        concurrentAccessExceptionArray[0] = ex;
                    }
                    catch (CommitException ex) {
                        throw ex.wrap();
                    }
                });
                if (exception[0] == null) {
                    CDOCommitInfo cDOCommitInfo = result[0];
                    return cDOCommitInfo;
                }
            }
            ++i;
        }
        if (exception[0] != null) {
            throw exception[0].wrap();
        }
        return result[0];
    }

    private class AbandonTransition
    extends AbstractTransition {
        private AbandonTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleAbandon(review);
            return ReviewStatus.ABANDONED;
        }
    }

    private abstract class AbstractTransition
    implements ITransition<ReviewStatus, ReviewEvent, REVIEW, Object> {
        private AbstractTransition() {
        }

        public final void execute(REVIEW review, ReviewStatus status, ReviewEvent event, Object data) {
            ReviewStatemachine.modify(review, transactionalReview -> {
                ReviewStatus newStatus = this.execute(transactionalReview, status, data);
                if (newStatus != status) {
                    ReviewStatemachine.this.changeState(transactionalReview, newStatus);
                }
            });
        }

        protected abstract ReviewStatus execute(REVIEW var1, ReviewStatus var2, Object var3);
    }

    public static abstract class Client<REVIEW extends Review>
    extends ReviewStatemachine<REVIEW> {
        public Client(boolean dropReviews) {
            super(true, dropReviews);
        }

        @Override
        protected final void handleCommitInSource(REVIEW review) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final void handleCommitInTarget(REVIEW review) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final ReviewStatus handleRestoreFinish(REVIEW review) {
            throw new UnsupportedOperationException();
        }
    }

    private class CommitInSourceTransition
    extends AbstractTransition {
        private CommitInSourceTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleCommitInSource(review);
            return status == ReviewStatus.NEW ? ReviewStatus.SOURCE_OUTDATED : ReviewStatus.OUTDATED;
        }
    }

    private class CommitInTargetTransition
    extends AbstractTransition {
        private CommitInTargetTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleCommitInTarget(review);
            return status == ReviewStatus.NEW ? ReviewStatus.TARGET_OUTDATED : ReviewStatus.OUTDATED;
        }
    }

    private class DeleteTranstion
    extends AbstractTransition {
        private DeleteTranstion() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleDelete(review);
            return ReviewStatus.DELETED;
        }
    }

    public static final class MergeFromSourceResult {
        public long sourceCommit = -1L;
        public long targetCommit = -1L;

        public boolean isSuccess() {
            return this.targetCommit != -1L;
        }
    }

    private class MergeFromSourceTransition
    extends AbstractTransition {
        private MergeFromSourceTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleMergeFromSource(review, (MergeFromSourceResult)data);
            return status == ReviewStatus.OUTDATED ? ReviewStatus.TARGET_OUTDATED : ReviewStatus.NEW;
        }
    }

    public static final class RebaseToTargetResult {
        public CDOBranchRef rebaseBranch;
        public long targetCommit = -1L;
        public boolean success;

        public boolean isSuccess() {
            return this.success;
        }
    }

    private class RebaseToTargetTransition
    extends AbstractTransition {
        private RebaseToTargetTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleRebaseToTarget(review, (RebaseToTargetResult)data);
            return status == ReviewStatus.OUTDATED ? ReviewStatus.SOURCE_OUTDATED : ReviewStatus.NEW;
        }
    }

    private class RestoreFinishTransition
    extends AbstractTransition {
        private RestoreFinishTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            return ReviewStatemachine.this.handleRestoreFinish(review);
        }
    }

    private class RestoreTransition
    extends AbstractTransition {
        private RestoreTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleRestore(review);
            return ReviewStatus.RESTORING;
        }
    }

    public static enum ReviewEvent {
        CommitInSource(false, true, true, false),
        CommitInTarget(false, true, true, false),
        MergeFromSource(true, false, true, true),
        RebaseToTarget(true, false, true, true),
        Submit(true, false, true, true),
        Abandon(true, false, true, true),
        Restore(true, false, true, true),
        Finish(false, true, true, true),
        Delete(true, false, true, true);

        private final boolean client;
        private final boolean server;
        private final boolean delivery;
        private final boolean drop;

        private ReviewEvent(boolean client, boolean server, boolean delivery, boolean drop) {
            this.client = client;
            this.server = server;
            this.delivery = delivery;
            this.drop = drop;
        }

        public boolean isClient() {
            return this.client;
        }

        public boolean isServer() {
            return this.server;
        }

        public boolean isDelivery() {
            return this.delivery;
        }

        public boolean isDrop() {
            return this.drop;
        }
    }

    public static abstract class Server<REVIEW extends Review>
    extends ReviewStatemachine<REVIEW> {
        public Server(boolean dropReviews) {
            super(false, dropReviews);
        }

        @Override
        protected void handleMergeFromSource(REVIEW review, MergeFromSourceResult result) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void handleRebaseToTarget(REVIEW review, RebaseToTargetResult result) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final void handleSubmit(REVIEW review, FixedBaseline submitResult) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final void handleAbandon(REVIEW review) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final void handleRestore(REVIEW review) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final void handleDelete(REVIEW review) {
            throw new UnsupportedOperationException();
        }
    }

    private class SubmitTransition
    extends AbstractTransition {
        private SubmitTransition() {
        }

        @Override
        public ReviewStatus execute(REVIEW review, ReviewStatus status, Object data) {
            ReviewStatemachine.this.handleSubmit(review, (FixedBaseline)data);
            return ReviewStatus.SUBMITTED;
        }
    }
}

