/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.function.Consumer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SafeTreeViewer
extends TreeViewer {
    private final Consumer<Exception> exceptionHandler;

    public SafeTreeViewer(Tree tree, Consumer<Exception> exceptionHandler) {
        super(tree);
        this.exceptionHandler = exceptionHandler;
    }

    public SafeTreeViewer(Composite parent, int style, Consumer<Exception> exceptionHandler) {
        super(parent, style);
        this.exceptionHandler = exceptionHandler;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        block2: {
            try {
                super.doUpdateItem(widget, element, fullMap);
            }
            catch (Exception ex) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.accept(ex);
            }
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        block2: {
            try {
                super.doUpdateItem(item, element);
            }
            catch (Exception ex) {
                if (this.exceptionHandler == null) break block2;
                this.exceptionHandler.accept(ex);
            }
        }
    }

    public boolean isExpandable(Object element) {
        try {
            return super.isExpandable(element);
        }
        catch (Exception ex) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.accept(ex);
            }
            return false;
        }
    }
}

