/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.cdo.internal.net4j.testrecorder.TestRecorderSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.internal.cdo.session.CDOSessionConfigurationImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.io.IStreamWrapper;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDONet4jSessionConfigurationImpl
extends CDOSessionConfigurationImpl
implements CDOSessionConfiguration {
    private static final boolean TEST_RECORDER = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.test.recorder.enabled");
    private String repositoryName;
    private IConnector connector;
    private IStreamWrapper streamWrapper;
    private long signalTimeout = 10000L;

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public IConnector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(IConnector connector) {
        this.checkNotOpen();
        this.uncheckedSetConnector(connector);
    }

    protected void uncheckedSetConnector(IConnector connector) {
        this.connector = connector;
    }

    @Override
    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    @Override
    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.checkNotOpen();
        this.streamWrapper = streamWrapper;
    }

    @Override
    public long getSignalTimeout() {
        return this.signalTimeout;
    }

    @Override
    public void setSignalTimeout(long signalTimeout) {
        this.signalTimeout = signalTimeout;
    }

    @Override
    public CDONet4jSession openNet4jSession() {
        return (CDONet4jSession)super.openSession();
    }

    @Override
    public CDOSession openSession() {
        return (CDOSession)this.openNet4jSession();
    }

    public InternalCDOSession createSession() {
        if (this.isActivateOnOpen()) {
            CheckUtil.checkState((Object)this.connector, (String)"connector");
        }
        if (TEST_RECORDER) {
            return new TestRecorderSession();
        }
        return new CDONet4jSessionImpl();
    }

    protected void configureSession(InternalCDOSession session) {
        super.configureSession(session);
        CDONet4jSessionImpl sessionImpl = (CDONet4jSessionImpl)session;
        sessionImpl.setStreamWrapper(this.streamWrapper);
        sessionImpl.setConnector(this.connector);
        sessionImpl.setRepositoryName(this.repositoryName);
        sessionImpl.setUserID(this.getUserID());
        sessionImpl.setSignalTimeout(this.signalTimeout);
    }

    public static class RepositoryInfo
    extends PlatformObject
    implements CDORepositoryInfo {
        private String uuid;
        private String name;
        private CDOCommonRepository.Type type;
        private CDOCommonRepository.State state;
        private String storeType;
        private Set<CDOID.ObjectType> objectIDTypes;
        private long creationTime;
        private CDOSessionProtocol.RepositoryTimeResult timeResult;
        private CDOID rootResourceID;
        private boolean authenticating;
        private boolean supportingLoginPeeks;
        private boolean supportingAudits;
        private boolean supportingBranches;
        private boolean supportingUnits;
        private boolean serializingCommits;
        private boolean ensuringReferentialIntegrity;
        private boolean authorizingOperations;
        private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
        private String lobDigestAlgorithm;
        private CDOCommonRepository.CommitInfoStorage commitInfoStorage;
        private InternalCDOSession session;

        public RepositoryInfo(InternalCDOSession session, CDOSessionProtocol.OpenSessionResult result) {
            this.session = session;
            this.uuid = result.getUUID();
            this.name = result.getName();
            this.type = result.getType();
            this.state = result.getState();
            this.storeType = result.getStoreType();
            this.objectIDTypes = result.getObjectIDTypes();
            this.creationTime = result.getCreationTime();
            this.timeResult = result.getRepositoryTimeResult();
            this.rootResourceID = result.getRootResourceID();
            this.authenticating = result.isAuthenticating();
            this.supportingLoginPeeks = result.isSupportingLoginPeeks();
            this.supportingAudits = result.isSupportingAudits();
            this.supportingBranches = result.isSupportingBranches();
            this.supportingUnits = result.isSupportingUnits();
            this.serializingCommits = result.isEnsuringReferentialIntegrity();
            this.ensuringReferentialIntegrity = result.isEnsuringReferentialIntegrity();
            this.authorizingOperations = result.isAuthorizingOperations();
            this.idGenerationLocation = result.getIDGenerationLocation();
            this.lobDigestAlgorithm = result.getLobDigestAlgorithm();
            this.commitInfoStorage = result.getCommitInfoStorage();
        }

        public InternalCDOSession getSession() {
            return this.session;
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public CDOCommonRepository.Type getType() {
            return this.type;
        }

        public void setType(CDOCommonRepository.Type type) {
            this.type = type;
        }

        public CDOCommonRepository.State getState() {
            return this.state;
        }

        public void setState(CDOCommonRepository.State state) {
            this.state = state;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return this.objectIDTypes;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getTimeStamp() {
            return this.getTimeStamp(false);
        }

        public long getTimeStamp(boolean forceRefresh) {
            if (this.timeResult == null || forceRefresh) {
                this.timeResult = this.refreshTime();
            }
            return this.timeResult.getAproximateRepositoryTime();
        }

        public CDOID getRootResourceID() {
            return this.rootResourceID;
        }

        public void setRootResourceID(CDOID rootResourceID) {
            if (this.rootResourceID == null || this.rootResourceID.isNull()) {
                this.rootResourceID = rootResourceID;
            } else if (this.rootResourceID == null || !this.rootResourceID.equals(rootResourceID)) {
                throw new IllegalStateException("rootResourceID must not be changed unless it is null");
            }
        }

        public boolean isAuthenticating() {
            return this.authenticating;
        }

        public boolean isSupportingLoginPeeks() {
            return this.supportingLoginPeeks;
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        public boolean isSupportingBranches() {
            return this.supportingBranches;
        }

        public boolean isSupportingUnits() {
            return this.supportingUnits;
        }

        @Deprecated
        public boolean isSupportingEcore() {
            return true;
        }

        public boolean isSerializingCommits() {
            return this.serializingCommits;
        }

        public boolean isEnsuringReferentialIntegrity() {
            return this.ensuringReferentialIntegrity;
        }

        public boolean isAuthorizingOperations() {
            return this.authorizingOperations;
        }

        public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
            return this.idGenerationLocation;
        }

        public String getLobDigestAlgorithm() {
            return this.lobDigestAlgorithm;
        }

        public CDOCommonRepository.CommitInfoStorage getCommitInfoStorage() {
            return this.commitInfoStorage;
        }

        public boolean waitWhileInitial(IProgressMonitor monitor) {
            return CDOCommonUtil.waitWhileInitial((CDOCommonRepository)this, (INotifier)this.session, (IProgressMonitor)monitor);
        }

        private CDOSessionProtocol.RepositoryTimeResult refreshTime() {
            return this.session.getSessionProtocol().getRepositoryTime();
        }
    }
}

