/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.impl.store.raw.log.FlushedScan;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class FlushedScanHandle
implements ScanHandle {
    LogFactory lf;
    StreamLogScan fs;
    LogRecord lr = null;
    boolean readOptionalData = false;
    int groupsIWant;
    ArrayInputStream rawInput = new ArrayInputStream(new byte[4096]);

    FlushedScanHandle(LogToFile lf, DatabaseInstant start, int groupsIWant) throws StandardException {
        this.lf = lf;
        this.fs = new FlushedScan(lf, ((LogCounter)start).getValueAsLong());
        this.groupsIWant = groupsIWant;
    }

    @Override
    public boolean next() throws StandardException {
        this.readOptionalData = false;
        this.lr = null;
        try {
            this.lr = this.fs.getNextRecord(this.rawInput, null, this.groupsIWant);
            if (this.lr == null) {
                return false;
            }
            if ((this.groupsIWant & this.lr.group()) == 0) {
                SanityManager.THROWASSERT(this.groupsIWant + "/" + this.lr.group());
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe, new Object[0]));
        }
    }

    @Override
    public int getGroup() throws StandardException {
        return this.lr.group();
    }

    @Override
    public Loggable getLoggable() throws StandardException {
        try {
            return this.lr.getLoggable();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe, new Object[0]));
        }
        catch (ClassNotFoundException cnfe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", cnfe, new Object[0]));
        }
    }

    @Override
    public InputStream getOptionalData() throws StandardException {
        SanityManager.ASSERT(!this.readOptionalData);
        if (this.lr == null) {
            return null;
        }
        try {
            int dataLength = this.rawInput.readInt();
            this.readOptionalData = true;
            this.rawInput.setLimit(dataLength);
            return this.rawInput;
        }
        catch (IOException ioe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe, new Object[0]));
        }
    }

    @Override
    public DatabaseInstant getInstant() throws StandardException {
        return this.fs.getLogInstant();
    }

    @Override
    public Object getTransactionId() throws StandardException {
        try {
            return this.lr.getTransactionId();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA2.D", ioe, new Object[0]));
        }
        catch (ClassNotFoundException cnfe) {
            this.fs.close();
            this.fs = null;
            throw this.lf.markCorrupt(StandardException.newException("XSLA3.D", cnfe, new Object[0]));
        }
    }

    @Override
    public void close() {
        if (this.fs != null) {
            this.fs.close();
        }
        this.fs = null;
    }
}

