/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

final class StorageFactoryService
implements PersistentService {
    private static final String SERVICE_PROPERTIES_EOF_TOKEN = "#--- last line, don't put anything after this line ---";
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class<?> storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String subSubProtocol, Class storageFactoryClass) throws StandardException {
        this.subSubProtocol = subSubProtocol;
        this.storageFactoryClass = storageFactoryClass;
        Object monitorEnv = StorageFactoryService.getMonitor().getEnvironment();
        if (monitorEnv instanceof File) {
            File relativeRoot = (File)monitorEnv;
            try {
                StorageFile rootDir;
                boolean created;
                this.home = relativeRoot.getPath();
                this.canonicalHome = relativeRoot.getCanonicalPath();
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
                if (this.home != null && (created = (rootDir = this.rootStorageFactory.newStorageFile(null)).mkdirs())) {
                    rootDir.limitAccessToOwner();
                }
            }
            catch (IOException pae) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException ioe) {
                throw Monitor.exceptionStartingModule(ioe);
            }
        }
        this.separatorChar = this.rootStorageFactory.getSeparator();
    }

    @Override
    public boolean hasStorageFactory() {
        return true;
    }

    @Override
    public StorageFactory getStorageFactoryInstance(boolean useHome, String databaseName, String tempDirName, String uniqueName) throws StandardException, IOException {
        try {
            return this.privGetStorageFactoryInstance(useHome, databaseName, tempDirName, uniqueName);
        }
        catch (IOException ioe) {
            throw this.registeredClassInstanceError(ioe);
        }
        catch (InstantiationException ie) {
            throw this.registeredClassInstanceError(ie);
        }
        catch (IllegalAccessException ia) {
            throw this.registeredClassInstanceError(ia);
        }
        catch (NoSuchMethodException nsme) {
            throw this.registeredClassInstanceError(nsme);
        }
        catch (InvocationTargetException ite) {
            throw this.registeredClassInstanceError(ite);
        }
    }

    private StandardException registeredClassInstanceError(Exception e) {
        return StandardException.newException("XBM0W.S", e, this.subSubProtocol, this.storageFactoryClass);
    }

    private StorageFactory privGetStorageFactoryInstance(boolean useHome, String databaseName, String tempDirName, String uniqueName) throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        String dbn = databaseName != null && this.subSubProtocol != null && databaseName.startsWith(this.subSubProtocol + ":") ? databaseName.substring(this.subSubProtocol.length() + 1) : databaseName;
        storageFactory.init(useHome ? this.home : null, dbn, tempDirName, uniqueName);
        return storageFactory;
    }

    @Override
    public String getType() {
        return this.subSubProtocol;
    }

    @Override
    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getServiceProperties(String serviceName, Properties defaultProperties) throws StandardException {
        if (!serviceName.equals(this.getCanonicalServiceName(serviceName))) {
            SanityManager.THROWASSERT("serviceName (" + serviceName + ") expected to equal getCanonicalServiceName(serviceName) (" + this.getCanonicalServiceName(serviceName) + ")");
        }
        String recreateFrom = this.recreateServiceRoot(serviceName, defaultProperties);
        Properties serviceProperties = new Properties(defaultProperties);
        try {
            if (recreateFrom != null) {
                File propFile = new File(recreateFrom, "service.properties");
                try (FileInputStream is = new FileInputStream(propFile);){
                    serviceProperties.load(new BufferedInputStream(is));
                }
            }
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, serviceName, null, null);
            StorageFile file = storageFactory.newStorageFile("service.properties");
            this.resolveServicePropertiesFiles(storageFactory, file);
            try (InputStream is = file.getInputStream();){
                serviceProperties.load(new BufferedInputStream(is));
            }
            finally {
                storageFactory.shutdown();
            }
            return serviceProperties;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
        catch (IOException ioe) {
            throw Monitor.exceptionStartingModule(ioe);
        }
        catch (InstantiationException ie) {
            throw Monitor.exceptionStartingModule(ie);
        }
        catch (IllegalAccessException ia) {
            throw Monitor.exceptionStartingModule(ia);
        }
        catch (NoSuchMethodException nsme) {
            throw Monitor.exceptionStartingModule(nsme);
        }
        catch (InvocationTargetException ite) {
            throw Monitor.exceptionStartingModule(ite);
        }
    }

    @Override
    public void saveServiceProperties(String serviceName, StorageFactory sf, Properties properties, boolean replace) throws StandardException {
        SanityManager.ASSERT(serviceName.equals(this.getCanonicalServiceName(serviceName)), serviceName);
        if (!(sf instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        WritableStorageFactory storageFactory = (WritableStorageFactory)sf;
        StorageFile backupFile = replace ? storageFactory.newStorageFile("service.properties".concat("old")) : null;
        StorageFile servicePropertiesFile = storageFactory.newStorageFile("service.properties");
        FileOperationHelper foh = new FileOperationHelper();
        if (replace) {
            foh.renameTo(servicePropertiesFile, backupFile, true);
        }
        OutputStream os = null;
        try {
            os = servicePropertiesFile.getOutputStream();
            properties.store(os, serviceName + MessageService.getTextMessage("M001", new Object[0]));
            BufferedWriter bOut = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"));
            bOut.write(SERVICE_PROPERTIES_EOF_TOKEN);
            bOut.newLine();
            storageFactory.sync(os, false);
            bOut.close();
            os.close();
            os = null;
        }
        catch (IOException ioe) {
            if (backupFile != null) {
                foh.renameTo(backupFile, servicePropertiesFile, false);
            }
            if (replace) {
                throw StandardException.newException("XBM0B.D", ioe, new Object[0]);
            }
            throw Monitor.exceptionStartingModule(ioe);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (backupFile != null && !foh.delete(backupFile, false)) {
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(backupFile)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataWarningFile(StorageFactory sf) throws StandardException {
        if (!(sf instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        WritableStorageFactory storageFactory = (WritableStorageFactory)sf;
        OutputStreamWriter osw = null;
        try {
            StorageFile fileReadMe = storageFactory.newStorageFile("README_DO_NOT_TOUCH_FILES.txt");
            osw = new OutputStreamWriter(fileReadMe.getOutputStream(), "UTF8");
            osw.write(MessageService.getTextMessage("M005", new Object[0]));
        }
        catch (IOException iOException) {
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void saveServiceProperties(String serviceName, Properties properties) throws StandardException {
        File servicePropertiesFile = new File(serviceName, "service.properties");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(servicePropertiesFile);
            FileUtil.limitAccessToOwner(servicePropertiesFile);
            properties.store(fos, serviceName + MessageService.getTextMessage("M001", new Object[0]));
            fos.getFD().sync();
            fos.close();
            fos = null;
        }
        catch (IOException ioe) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                fos = null;
            }
            throw Monitor.exceptionStartingModule(ioe);
        }
    }

    private void resolveServicePropertiesFiles(StorageFactory sf, StorageFile spf) throws StandardException {
        StorageFile spfOld = sf.newStorageFile("service.properties".concat("old"));
        FileOperationHelper foh = new FileOperationHelper();
        boolean hasCurrent = foh.exists(spf, true);
        boolean hasBackup = foh.exists(spfOld, true);
        if (hasCurrent && !hasBackup) {
            return;
        }
        if (hasBackup && !hasCurrent) {
            foh.renameTo(spfOld, spf, true);
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
        } else if (hasBackup && hasCurrent) {
            BufferedReader bin = null;
            String lastLine = null;
            try {
                String line;
                bin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(spf.getPath()), "ISO-8859-1"));
                while ((line = bin.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    lastLine = line;
                }
            }
            catch (IOException ioe) {
                throw StandardException.newException("XJ113.S", ioe, spf.getPath(), ioe.getMessage());
            }
            finally {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (lastLine != null && lastLine.startsWith(SERVICE_PROPERTIES_EOF_TOKEN)) {
                String msg = foh.delete(spfOld, false) ? MessageService.getTextMessage("M003", new Object[0]) : MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(spfOld));
                Monitor.getStream().printlnWithHeader(msg);
            } else {
                foh.delete(spf, false);
                foh.renameTo(spfOld, spf, true);
                Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String recreateServiceRoot(String serviceName, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean createRoot = false;
        boolean deleteExistingRoot = false;
        String restoreFrom = properties.getProperty("createFrom");
        if (restoreFrom != null) {
            createRoot = true;
            deleteExistingRoot = false;
        } else {
            restoreFrom = properties.getProperty("restoreFrom");
            if (restoreFrom != null) {
                createRoot = true;
                deleteExistingRoot = true;
            } else {
                restoreFrom = properties.getProperty("rollForwardRecoveryFrom");
                if (restoreFrom != null) {
                    try {
                        StorageFactoryService sfs = null;
                        StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, serviceName, null, null);
                        try {
                            StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                            sfs = serviceDirectory.exists() ? this : null;
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                        if (sfs == null) {
                            createRoot = true;
                            deleteExistingRoot = false;
                        }
                    }
                    catch (IOException ioe) {
                        throw Monitor.exceptionStartingModule(ioe);
                    }
                    catch (InstantiationException ie) {
                        throw Monitor.exceptionStartingModule(ie);
                    }
                    catch (IllegalAccessException ia) {
                        throw Monitor.exceptionStartingModule(ia);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw Monitor.exceptionStartingModule(nsme);
                    }
                    catch (InvocationTargetException ite) {
                        throw Monitor.exceptionStartingModule(ite);
                    }
                }
            }
        }
        if (restoreFrom != null) {
            block32: {
                File backupRoot = new File(restoreFrom);
                if (this.fileExists(backupRoot)) {
                    File bserviceProp = new File(restoreFrom, "service.properties");
                    if (this.fileExists(bserviceProp)) {
                        if (createRoot) {
                            this.createServiceRoot(serviceName, deleteExistingRoot);
                        }
                        try {
                            WritableStorageFactory storageFactory = (WritableStorageFactory)this.privGetStorageFactoryInstance(true, serviceName, null, null);
                            try {
                                StorageFile cserviceProp = storageFactory.newStorageFile("service.properties");
                                if (cserviceProp.exists() && !cserviceProp.delete()) {
                                    throw StandardException.newException("XBM0R.D", cserviceProp);
                                }
                                break block32;
                            }
                            finally {
                                storageFactory.shutdown();
                            }
                        }
                        catch (IOException ioe) {
                            throw Monitor.exceptionStartingModule(ioe);
                        }
                        catch (InstantiationException ie) {
                            throw Monitor.exceptionStartingModule(ie);
                        }
                        catch (IllegalAccessException ia) {
                            throw Monitor.exceptionStartingModule(ia);
                        }
                        catch (NoSuchMethodException nsme) {
                            throw Monitor.exceptionStartingModule(nsme);
                        }
                        catch (InvocationTargetException ite) {
                            throw Monitor.exceptionStartingModule(ite);
                        }
                    }
                    throw StandardException.newException("XBM0Q.D", bserviceProp);
                }
                throw StandardException.newException("XBM0Y.D", backupRoot);
            }
            properties.put("derby.__rt.inRestore", "True");
            if (createRoot) {
                properties.put("derby.__rt.deleteRootOnError", "True");
            }
        }
        return restoreFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createServiceRoot(String name, boolean deleteExisting) throws StandardException {
        String instantiationString;
        block16: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D", new Object[0]);
            }
            instantiationString = null;
            try {
                StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, name, null, null);
                try {
                    StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                    if (serviceDirectory.exists()) {
                        if (deleteExisting) {
                            if (!serviceDirectory.deleteAll()) {
                                throw StandardException.newException("XBM0I.D", this.getDirectoryPath(name));
                            }
                        } else {
                            this.vetService(storageFactory, name);
                            throw StandardException.newException("XBM0J.D", this.getDirectoryPath(name));
                        }
                    }
                    if (!serviceDirectory.mkdirs()) break block16;
                    serviceDirectory.limitAccessToOwner();
                    String serviceDirCanonicalPath = serviceDirectory.getCanonicalPath();
                    storageFactory.setCanonicalName(serviceDirCanonicalPath);
                    try {
                        instantiationString = storageFactory.getCanonicalName();
                    }
                    catch (IOException ioe) {
                        serviceDirectory.deleteAll();
                        throw ioe;
                    }
                }
                finally {
                    storageFactory.shutdown();
                }
            }
            catch (IOException ioe) {
                throw this.serviceDirectoryCreateError(ioe, name);
            }
            catch (InstantiationException ie) {
                throw this.serviceDirectoryCreateError(ie, name);
            }
            catch (IllegalAccessException ia) {
                throw this.serviceDirectoryCreateError(ia, name);
            }
            catch (NoSuchMethodException nsme) {
                throw this.serviceDirectoryCreateError(nsme, name);
            }
            catch (InvocationTargetException ite) {
                throw this.serviceDirectoryCreateError(ite, name);
            }
        }
        return this.getProtocolLeadIn() + instantiationString;
    }

    private StandardException serviceDirectoryCreateError(Exception t, String name) {
        return StandardException.newException("XBM0H.D", t, name);
    }

    private void vetService(StorageFactory storageFactory, String serviceName) throws StandardException {
        StorageFile seg0;
        StorageFile service_properties = storageFactory.newStorageFile("service.properties");
        if (!service_properties.exists() && (seg0 = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException("XBM0A.D", serviceName, "service.properties");
        }
    }

    private String getDirectoryPath(String name) {
        StringBuffer sb = new StringBuffer();
        if (this.home != null) {
            sb.append(this.home);
            sb.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            sb.append(name.replace('/', this.separatorChar));
        } else {
            sb.append(name);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeServiceRoot(String serviceName) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            StorageFactoryService sfs = null;
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, serviceName, null, null);
            try {
                String tmpCanonical = this.getCanonicalServiceName(this.getProtocolLeadIn() + storageFactory.getCanonicalName());
                SanityManager.ASSERT(tmpCanonical.equals(this.getProtocolLeadIn() + storageFactory.getCanonicalName()));
                SanityManager.ASSERT(serviceName.equals(tmpCanonical), "serviceName = " + serviceName + " ; protocolLeadIn + storageFactory.getCanoicalName = " + tmpCanonical);
                StorageFile serviceDirectory = storageFactory.newStorageFile(null);
                sfs = serviceDirectory.deleteAll() ? this : null;
            }
            finally {
                storageFactory.shutdown();
            }
            return sfs != null;
        }
        catch (Exception pae) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCanonicalServiceName(String name) throws StandardException {
        int colon = name.indexOf(58);
        if (colon < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (colon > 1) {
            if (!name.startsWith(this.getType() + ":")) {
                return null;
            }
            name = name.substring(colon + 1);
        }
        String nm = name;
        try {
            String rawName = null;
            StorageFactory storageFactory = this.privGetStorageFactoryInstance(true, nm, null, null);
            try {
                rawName = storageFactory.getCanonicalName();
            }
            finally {
                storageFactory.shutdown();
            }
            return this.getProtocolLeadIn() + rawName;
        }
        catch (Exception pae) {
            throw Monitor.exceptionStartingModule(pae);
        }
    }

    @Override
    public String getUserServiceName(String serviceName) {
        if (this.home != null && serviceName.length() > this.canonicalHome.length() + 1 && serviceName.startsWith(this.canonicalHome) && (serviceName = serviceName.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            serviceName = serviceName.substring(1);
        }
        return serviceName.replace(this.separatorChar, '/');
    }

    @Override
    public boolean isSameService(String serviceName1, String serviceName2) {
        try {
            SanityManager.ASSERT(serviceName1.equals(this.getCanonicalServiceName(serviceName1)), serviceName1);
            SanityManager.ASSERT(serviceName2.equals(this.getCanonicalServiceName(serviceName2)), serviceName2);
        }
        catch (StandardException se) {
            return false;
        }
        return serviceName1.equals(serviceName2);
    }

    private final boolean fileExists(File file) {
        return file.exists();
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static String getMostAccuratePath(StorageFile file) {
        String path = file.getPath();
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    final class DirectoryList
    implements Enumeration {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            this.run();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return this.run() != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        public final DirectoryList run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile properties;
                            String dirname = this.contents[this.index];
                            StorageFile dir = StorageFactoryService.this.rootStorageFactory.newStorageFile(dirname);
                            if (dir.isDirectory() && (properties = StorageFactoryService.this.rootStorageFactory.newStorageFile(dir, "service.properties")).exists()) {
                                this.contents[this.index] = dir.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception se) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }

    private static class FileOperationHelper {
        private String operation;

        private FileOperationHelper() {
        }

        boolean exists(StorageFile file, boolean mustSucceed) throws StandardException {
            this.operation = "exists";
            boolean ret = false;
            ret = file.exists();
            return ret;
        }

        boolean delete(StorageFile file, boolean mustSucceed) throws StandardException {
            this.operation = "delete";
            boolean deleted = false;
            deleted = file.delete();
            if (mustSucceed && !deleted) {
                throw StandardException.newException("XBM0R.D", file.getPath());
            }
            return deleted;
        }

        boolean renameTo(StorageFile from, StorageFile to, boolean mustSucceed) throws StandardException {
            this.operation = "renameTo";
            this.delete(to, false);
            boolean renamed = false;
            renamed = from.renameTo(to);
            if (mustSucceed && !renamed) {
                throw StandardException.newException("XBM0S.D", from.getPath(), to.getPath());
            }
            return renamed;
        }
    }
}

