/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

class SignedBinary {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    private SignedBinary() {
    }

    public static short getShort(byte[] buffer, int offset, int byteOrder) {
        switch (byteOrder) {
            case 1: {
                return SignedBinary.bigEndianBytesToShort(buffer, offset);
            }
            case 2: {
                return SignedBinary.littleEndianBytesToShort(buffer, offset);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getInt(byte[] buffer, int offset, int byteOrder) {
        switch (byteOrder) {
            case 1: {
                return SignedBinary.bigEndianBytesToInt(buffer, offset);
            }
            case 2: {
                return SignedBinary.littleEndianBytesToInt(buffer, offset);
            }
        }
        throw new IllegalArgumentException();
    }

    public static long getLong(byte[] buffer, int offset, int byteOrder) {
        switch (byteOrder) {
            case 1: {
                return SignedBinary.bigEndianBytesToLong(buffer, offset);
            }
            case 2: {
                return SignedBinary.littleEndianBytesToLong(buffer, offset);
            }
        }
        throw new IllegalArgumentException();
    }

    public static short bigEndianBytesToShort(byte[] buffer, int offset) {
        return (short)(((buffer[offset + 0] & 0xFF) << 8) + ((buffer[offset + 1] & 0xFF) << 0));
    }

    public static short littleEndianBytesToShort(byte[] buffer, int offset) {
        return (short)(((buffer[offset + 0] & 0xFF) << 0) + ((buffer[offset + 1] & 0xFF) << 8));
    }

    public static int bigEndianBytesToInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + ((buffer[offset + 3] & 0xFF) << 0);
    }

    public static int littleEndianBytesToInt(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 0) + ((buffer[offset + 1] & 0xFF) << 8) + ((buffer[offset + 2] & 0xFF) << 16) + ((buffer[offset + 3] & 0xFF) << 24);
    }

    public static long bigEndianBytesToLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + (((long)buffer[offset + 7] & 0xFFL) << 0);
    }

    public static long littleEndianBytesToLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 0) + (((long)buffer[offset + 1] & 0xFFL) << 8) + (((long)buffer[offset + 2] & 0xFFL) << 16) + (((long)buffer[offset + 3] & 0xFFL) << 24) + (((long)buffer[offset + 4] & 0xFFL) << 32) + (((long)buffer[offset + 5] & 0xFFL) << 40) + (((long)buffer[offset + 6] & 0xFFL) << 48) + (((long)buffer[offset + 7] & 0xFFL) << 56);
    }
}

