/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.provider;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Font;

public final class URIStyler {
    public static final int WORKSPACE = 0;
    public static final int EXTERNAL = 1;
    public static final int MISSING = 2;
    private static final URI COLOR_WORKSPACE = URI.createURI((String)"color://rgb/0/0/0");
    private static final URI COLOR_EXTERNAL = URI.createURI((String)"color://rgb/128/128/150");
    private static final URI COLOR_MISSING = URI.createURI((String)"color://rgb/220/60/60");
    private static final URI FONT_BOLD = URI.createURI((String)"font:////bold");
    private static final StyledString.Style[][] STYLES = new StyledString.Style[][]{URIStyler.styles(COLOR_WORKSPACE), URIStyler.styles(COLOR_EXTERNAL), URIStyler.styles(COLOR_MISSING)};
    private static final StyledString EMPTY = new StyledString();

    private URIStyler() {
    }

    public static void setDefaultFont(Font font) {
        EMFLabelProvider.INSTANCE.setDefaultFont(font);
    }

    public static StyledString getEMFStyledURI(URI uri, int colorIndex) {
        if (uri == null) {
            return EMPTY;
        }
        String fragment = uri.fragment();
        uri = uri.trimFragment();
        String lastSegment = uri.lastSegment();
        uri = uri.trimSegments(1).appendSegment("");
        StyledString styledLabel = new StyledString();
        styledLabel.append(uri.toString(), STYLES[colorIndex][0]);
        styledLabel.append(lastSegment, STYLES[colorIndex][1]);
        styledLabel.append(fragment, STYLES[colorIndex][0]);
        return styledLabel;
    }

    public static org.eclipse.jface.viewers.StyledString getJFaceStyledURI(URI uri, int colorIndex) {
        if (EMFLabelProvider.INSTANCE.getDefaultFont() == null) {
            throw new IllegalStateException("setDefaultFont() must be called");
        }
        StyledString emfStyledURI = URIStyler.getEMFStyledURI(uri, colorIndex);
        return EMFLabelProvider.INSTANCE.toJFaceStyledString(emfStyledURI);
    }

    private static StyledString.Style[] styles(URI color) {
        return new StyledString.Style[]{StyledString.Style.newBuilder().setForegroundColor(color).toStyle(), StyledString.Style.newBuilder().setForegroundColor(color).setFont(FONT_BOLD).toStyle()};
    }

    private static final class EMFLabelProvider
    extends AdapterFactoryLabelProvider {
        private static final EMFLabelProvider INSTANCE = new EMFLabelProvider();

        private EMFLabelProvider() {
            super(null);
        }

        public org.eclipse.jface.viewers.StyledString toJFaceStyledString(StyledString styledString) {
            return super.toJFaceStyledString(styledString);
        }
    }
}

