/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import org.eclipse.net4j.internal.util.bundle.OM;

public abstract class AbstractSupport {
    private Boolean available;

    protected AbstractSupport() {
    }

    public boolean isAvailable() {
        if (this.available == null) {
            try {
                this.available = this.determineAvailability();
            }
            catch (Throwable ex) {
                this.available = false;
            }
        }
        return this.available;
    }

    protected abstract boolean determineAvailability() throws Throwable;

    public static class ClassAvailability
    extends AbstractSupport {
        private final String pluginID;
        private final String className;

        public ClassAvailability(String pluginID, String className) {
            this.pluginID = pluginID;
            this.className = className;
        }

        @Override
        protected boolean determineAvailability() throws Throwable {
            return OM.BUNDLE.loadClass(this.pluginID, this.className) != null;
        }
    }
}

