/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.factory.FactoryDescriptor;
import org.eclipse.net4j.internal.util.factory.SimpleFactory;
import org.eclipse.net4j.internal.util.om.pref.Preferences;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.Logger;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.eclipse.net4j.util.om.trace.Tracer;
import org.w3c.dom.Document;

public abstract class AbstractBundle
implements OMBundle,
OMBundle.DebugSupport,
OMBundle.TranslationSupport {
    private static final String CLASS_EXTENSION = ".class";
    private static final String STACK_TRACE_ELEMENT = StackTraceElement[].class.getName();
    private static final String EXT_POINT_FACTORIES = "org.eclipse.net4j.util.factories";
    private static final String EXT_POINT_ELEMENT_PROCESSORS = "org.eclipse.net4j.util.elementProcessors";
    private AbstractPlatform platform;
    private String bundleID;
    private Class<?> accessor;
    private Object bundleContext;
    private boolean debugging;
    private Map<String, Tracer> tracers = new ConcurrentHashMap<String, Tracer>(0);
    private OMLogger logger;
    private Preferences preferences;
    private ResourceBundle resourceBundle;
    private ResourceBundle untranslatedResourceBundle;
    private Map<String, String> strings = new HashMap<String, String>(0);
    private Map<String, String> untranslatedStrings = new HashMap<String, String>(0);
    private boolean shouldTranslate = true;
    private String userLocation;

    public AbstractBundle(AbstractPlatform platform, String bundleID, Class<?> accessor) {
        this.platform = platform;
        this.bundleID = bundleID;
        this.accessor = accessor;
        boolean debug = this.getDebugOption("debug", false);
        this.setDebugging(debug);
        this.userLocation = new File(platform.getUserFolder(), bundleID).toString();
    }

    @Override
    public OMPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public String getBundleID() {
        return this.bundleID;
    }

    public Class<?> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(Class<?> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass v) throws ClassNotFoundException {
        String className = v.getName();
        try {
            ClassLoader classLoader = this.accessor.getClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (!STACK_TRACE_ELEMENT.equals(className)) {
                throw WrappedException.wrap(ex);
            }
            return null;
        }
    }

    public Object getBundleContext() {
        return this.bundleContext;
    }

    @Override
    @Deprecated
    public void setBundleContext(Object bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void prepareContainer(IManagedContainer container) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = this.getInputStream("plugin.xml");){
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(false);
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(in);
                Tree plugin = Tree.XMLConverter.convertDocumentToTree(document);
                for (Tree extension : plugin.children("extension")) {
                    Class<?> factoryClass;
                    String className;
                    if (EXT_POINT_FACTORIES.equals(extension.attribute("point"))) {
                        for (final Tree child : extension.children()) {
                            Class<?> productClass;
                            String type;
                            String productGroup;
                            String productClassName;
                            IFactory factory;
                            if ("factory".equals(child.name())) {
                                className = child.attribute("class");
                                factoryClass = this.loadClass(this.getBundleID(), className);
                                IFactory factory2 = (IFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                String type2 = child.attribute("type");
                                FactoryDescriptor.adjustFactoryType(factory2, type2);
                                container.registerFactory(factory2);
                                continue;
                            }
                            if ("factories".equals(child.name())) {
                                className = child.attribute("class");
                                factoryClass = this.loadClass(this.getBundleID(), className);
                                Constructor<?> factoryConstructor = factoryClass.getConstructor(new Class[0]);
                                for (Tree grandChild : child.children("type")) {
                                    factory = (IFactory)factoryConstructor.newInstance(new Object[0]);
                                    String type3 = grandChild.attribute("value");
                                    FactoryDescriptor.adjustFactoryType(factory, type3);
                                    container.registerFactory(factory);
                                }
                                continue;
                            }
                            if ("annotationFactory".equals(child.name())) {
                                productClassName = child.attribute("productClass");
                                productGroup = child.attribute("productGroup");
                                type = child.attribute("type");
                                productClass = this.loadClass(this.getBundleID(), productClassName);
                                AnnotationFactory factory3 = new AnnotationFactory(productClass, productGroup, type);
                                FactoryDescriptor.adjustFactoryType(factory3, type);
                                container.registerFactory(factory3);
                                continue;
                            }
                            if ("simpleFactory".equals(child.name())) {
                                productClassName = child.attribute("productClass");
                                productGroup = child.attribute("productGroup");
                                type = child.attribute("type");
                                productClass = this.loadClass(this.getBundleID(), productClassName);
                                final Constructor<?> productConstructor = productClass.getConstructor(new Class[0]);
                                factory = new Factory(productGroup, type){

                                    @Override
                                    public Object create(String description) throws ProductCreationException {
                                        try {
                                            Object product = productConstructor.newInstance(new Object[0]);
                                            if (product != null) {
                                                String setterName = child.attribute("setterName");
                                                SimpleFactory.configure(product, description, setterName);
                                            }
                                            return product;
                                        }
                                        catch (Exception ex) {
                                            throw this.productCreationException(description, ex);
                                        }
                                    }
                                };
                                container.registerFactory(factory);
                                continue;
                            }
                            if (!"constantFactory".equals(child.name())) continue;
                            String productGroup2 = child.attribute("productGroup");
                            String type4 = child.attribute("type");
                            String constantClassName = child.attribute("class");
                            String constantName = child.attribute("name");
                            if (StringUtil.isEmpty(constantName)) {
                                constantName = type4.toUpperCase();
                            }
                            Class<?> constantClass = OM.BUNDLE.loadClass(this.getBundleID(), constantClassName);
                            Field constantField = constantClass.getField(constantName);
                            final Object product = constantField.get(null);
                            Factory factory4 = new Factory(productGroup2, type4){

                                @Override
                                public Object create(String description) throws ProductCreationException {
                                    return product;
                                }
                            };
                            container.registerFactory(factory4);
                        }
                        continue;
                    }
                    if (!EXT_POINT_ELEMENT_PROCESSORS.equals(extension.attribute("point"))) continue;
                    for (final Tree child : extension.children()) {
                        className = child.attribute("class");
                        factoryClass = this.loadClass(this.getBundleID(), className);
                        IElementProcessor elementProcessor = (IElementProcessor)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        container.addPostProcessor(elementProcessor);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    @Override
    public OMBundle.DebugSupport getDebugSupport() {
        return this;
    }

    @Override
    public OMBundle.TranslationSupport getTranslationSupport() {
        return this;
    }

    @Override
    public boolean isDebugging() {
        if (!this.platform.isDebugging()) {
            return false;
        }
        return this.debugging;
    }

    @Override
    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Override
    public String getDebugOption(String option, String defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean getDebugOption(String option, boolean defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    @Override
    public void setDebugOption(String option, boolean value) {
        this.setDebugOption(option, Boolean.toString(value));
    }

    @Override
    public int getDebugOption(String option, int defaultValue) {
        try {
            String value = this.getDebugOption(option);
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setDebugOption(String option, int value) {
        this.setDebugOption(option, Integer.toString(value));
    }

    @Override
    public String getDebugOption(String option) {
        return this.platform.getDebugOption(this.bundleID, option);
    }

    @Override
    public void setDebugOption(String option, String value) {
        this.platform.setDebugOption(this.bundleID, option, value);
    }

    public void setDebugOptionIfAbsent(String option, String value) {
        this.platform.setDebugOption(this.bundleID, option, value, true);
    }

    @Override
    public synchronized OMTracer tracer(String name) {
        OMTracer tracer = this.tracers.get(name);
        if (tracer == null) {
            tracer = this.createTracer(name);
        }
        return tracer;
    }

    @Override
    public synchronized OMLogger logger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    @Override
    public IStatus getStatus(Object obj) {
        if (obj instanceof CoreException) {
            CoreException ex = (CoreException)obj;
            IStatus st = ex.getStatus();
            return new Status(st.getSeverity(), st.getPlugin(), st.getCode(), st.getMessage(), (Throwable)ex);
        }
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            String msg = t.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = t.getClass().getName();
            }
            return new Status(4, this.bundleID, msg, t);
        }
        return new Status(1, this.bundleID, obj.toString(), null);
    }

    @Override
    public void coreException(Throwable t) throws CoreException {
        if (t instanceof CoreException) {
            CoreException ex = (CoreException)t;
            IStatus status = ex.getStatus();
            if (status != null && status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            throw ex;
        }
        if (t instanceof OperationCanceledException) {
            throw (OperationCanceledException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        IStatus status = this.getStatus(t);
        throw new CoreException(status);
    }

    @Override
    public String getUserLocation() {
        return this.userLocation;
    }

    @Override
    public File getConfigFile() {
        return this.platform.getConfigFile(this.getConfigFileName());
    }

    @Override
    public Properties getConfigProperties() {
        return this.platform.getConfigProperties(this.getConfigFileName());
    }

    @Override
    public synchronized Preferences preferences() {
        if (this.preferences == null) {
            this.preferences = new Preferences(this);
        }
        return this.preferences;
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        String base = this.getBaseURL().toString();
        if (!base.endsWith("/")) {
            base = String.valueOf(base) + "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        URL url = IOUtil.newURL(String.valueOf(base) + path);
        return url.openStream();
    }

    @Override
    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    @Override
    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getString(String key, boolean translate) {
        stringMap = translate != false ? this.strings : this.untranslatedStrings;
        result = stringMap.get(key);
        if (result == null) {
            v0 = bundle = translate != false ? this.resourceBundle : this.untranslatedResourceBundle;
            if (bundle == null) {
                packageName = ReflectUtil.getPackageName(this.accessor);
                if (translate) {
                    try {
                        bundle = this.resourceBundle = ResourceBundle.getBundle(String.valueOf(packageName) + ".plugin");
                    }
                    catch (MissingResourceException exception) {
                        block15: {
                            inputStream = null;
                            try {
                                try {
                                    inputStream = this.getInputStream("plugin.properties");
                                    this.untranslatedResourceBundle = this.resourceBundle = (bundle = new PropertyResourceBundle(inputStream));
                                    inputStream.close();
                                }
                                catch (IOException var9_11) {
                                    IOUtil.closeSilent(inputStream);
                                    break block15;
                                }
                            }
                            catch (Throwable var10_13) {
                                IOUtil.closeSilent(inputStream);
                                throw var10_13;
                            }
                            IOUtil.closeSilent(inputStream);
                        }
                        if (this.resourceBundle != null) ** GOTO lbl49
                        throw exception;
                    }
                } else {
                    inputStream = null;
                    try {
                        try {
                            inputStream = this.getInputStream("plugin.properties");
                            bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
                            inputStream.close();
                        }
                        catch (IOException ioException) {
                            throw new MissingResourceException("Missing resource: plugin.properties", this.accessor.getName(), key);
                        }
                    }
                    catch (Throwable var9_12) {
                        IOUtil.closeSilent(inputStream);
                        throw var9_12;
                    }
                    IOUtil.closeSilent(inputStream);
                }
            }
lbl49:
            // 5 sources

            result = bundle.getString(key);
            stringMap.put(key, result);
        }
        return result;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    @Override
    public String getString(String key, Object ... args) {
        return this.getString(key, this.shouldTranslate(), args);
    }

    @Override
    public String getString(String key, boolean translate, Object ... args) {
        return MessageFormat.format(this.getString(key, translate), args);
    }

    public String toString() {
        return this.bundleID;
    }

    public void start() throws Exception {
        this.invokeMethod("start");
    }

    public void stop() throws Exception {
        try {
            if (this.preferences != null) {
                this.preferences.save();
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error(ex);
        }
        this.invokeMethod("stop");
    }

    protected OMTracer createTracer(String name) {
        return new Tracer(this, name);
    }

    protected OMLogger createLogger() {
        return new Logger(this);
    }

    protected String getConfigFileName() {
        return String.valueOf(this.bundleID) + ".properties";
    }

    protected final Class<?> getClassFromBundle(String path) {
        if (path.endsWith(CLASS_EXTENSION)) {
            int start = path.startsWith("/") ? 1 : 0;
            int end = path.length() - CLASS_EXTENSION.length();
            String className = path.substring(start, end).replace('/', '.');
            while (true) {
                try {
                    ClassLoader classLoader = this.getAccessor().getClassLoader();
                    Class<?> c = classLoader.loadClass(className);
                    if (c != null) {
                        return c;
                    }
                }
                catch (NoClassDefFoundError classLoader) {
                }
                catch (ClassNotFoundException classLoader) {
                    // empty catch block
                }
                int dot = className.indexOf(46);
                if (dot == -1) break;
                className = className.substring(dot + 1);
            }
        }
        return null;
    }

    private void invokeMethod(String name) throws Exception {
        try {
            Method method = this.accessor.getDeclaredMethod(name, ReflectUtil.NO_PARAMETERS);
            ReflectUtil.makeAccessible(method);
            method.invoke(null, ReflectUtil.NO_ARGUMENTS);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException method) {
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            OM.LOG.error(targetException);
        }
    }
}

