/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class CoolBarComposite
extends Composite {
    private CoolBarManager coolBarManager;
    private Control clientControl;
    private Label separator;
    private ToolBarManager toolBarManager;

    public CoolBarComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new CoolBarLayout());
        this.toolBarManager = new ToolBarManager(8520000);
        this.fillCoolBar((IContributionManager)this.toolBarManager);
        this.coolBarManager = new CoolBarManager(0x800100);
        this.coolBarManager.add((IToolBarManager)this.toolBarManager);
        this.coolBarManager.setLockLayout(true);
        this.coolBarManager.createControl((Composite)this);
        this.coolBarManager.update(true);
        this.separator = new Label((Composite)this, 258);
        this.separator.setLayoutData((Object)UIUtil.createGridData(true, false));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout(1));
        this.clientControl = this.createUI(composite);
        this.clientControl.setLayoutData((Object)UIUtil.createGridData());
    }

    public void dispose() {
        this.coolBarManager.dispose();
        super.dispose();
    }

    public Control getClientControl() {
        return this.clientControl;
    }

    public void updateCoolBar() {
        this.toolBarManager.removeAll();
        this.fillCoolBar((IContributionManager)this.toolBarManager);
        this.coolBarManager.update(true);
    }

    protected abstract Control createUI(Composite var1);

    protected CoolBar getCoolBarControl() {
        if (this.coolBarManager != null) {
            return this.coolBarManager.getControl();
        }
        return null;
    }

    protected void fillCoolBar(IContributionManager manager) {
    }

    public class CoolBarLayout
    extends Layout {
        static final int BAR_SIZE = 23;
        private static final int SEPARATOR_SIZE = 1;

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            boolean coolBarChildrenExist = this.coolBarChildrenExist();
            Point result = new Point(0, 0);
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                boolean hide = false;
                if (w == CoolBarComposite.this.getCoolBarControl()) {
                    if (!coolBarChildrenExist) {
                        hide = true;
                        result.y += 23;
                    }
                } else if (w == CoolBarComposite.this.separator) {
                    if (!coolBarChildrenExist) {
                        hide = true;
                        ++result.y;
                    }
                } else if (i > 0) {
                    hide = false;
                }
                if (!hide) {
                    Point e = w.computeSize(wHint, hHint, flushCache);
                    result.x = Math.max(result.x, e.x);
                    result.y += e.y;
                }
                ++i;
            }
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            boolean coolBarChildrenExist = this.coolBarChildrenExist();
            Rectangle clientArea = composite.getClientArea();
            Control[] ws = composite.getChildren();
            int i = 0;
            while (i < ws.length) {
                Control w = ws[i];
                if (w == CoolBarComposite.this.getCoolBarControl() || w == CoolBarComposite.this.separator) {
                    if (coolBarChildrenExist) {
                        Point e = w.computeSize(clientArea.width, -1, flushCache);
                        w.setBounds(clientArea.x, clientArea.y, clientArea.width, e.y);
                        clientArea.y += e.y;
                        clientArea.height -= e.y;
                    }
                } else {
                    w.setBounds(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                }
                ++i;
            }
        }

        protected boolean coolBarChildrenExist() {
            CoolBar coolBarControl = CoolBarComposite.this.getCoolBarControl();
            if (coolBarControl != null) {
                return coolBarControl.getItemCount() > 0;
            }
            return false;
        }
    }
}

