/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.ui.swt.TransferComposite;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TransferDialog
extends TitleAreaDialog {
    private final CDOTransfer transfer;
    private TransferComposite transferComposite;

    public TransferDialog(Shell parentShell, CDOTransfer transfer) {
        super(parentShell);
        this.setShellStyle(67696);
        this.transfer = transfer;
    }

    public final CDOTransfer getTransfer() {
        return this.transfer;
    }

    public final TransferComposite getTransferComposite() {
        return this.transferComposite;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Transfer from " + String.valueOf(this.transfer.getSourceSystem()) + " to " + String.valueOf(this.transfer.getTargetSystem()));
        this.setTitleImage(SharedIcons.getImage((String)"wizban/transfer_wiz.png"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new FillLayout());
        this.transferComposite = new TransferComposite(container, this.transfer);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        UIUtil.runWithProgress((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TransferDialog.this.transfer.perform(monitor);
                }
                catch (OperationCanceledException ex) {
                    throw new InterruptedException();
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        });
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(1000, 800);
    }

    public static boolean open(Shell shell, List<CDOTransferElement> sourceElements, CDOTransferElement targetElement) {
        CDOTransferSystem sourceSystem = sourceElements.get(0).getSystem();
        CDOTransferSystem targetSystem = targetElement.getSystem();
        CDOTransfer transfer = new CDOTransfer(sourceSystem, targetSystem);
        transfer.setTargetPath(targetElement.getPath());
        TransferDialog.initializeTransfer(transfer, sourceElements);
        TransferDialog dialog = new TransferDialog(shell, transfer);
        return dialog.open() == 0;
    }

    public static void initializeTransfer(final CDOTransfer transfer, final Collection<CDOTransferElement> sourceElements) {
        UIUtil.runWithProgress((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        CDOTransferSystem sourceSystem = transfer.getSourceSystem();
                        CDOTransferSystem targetSystem = transfer.getTargetSystem();
                        monitor.beginTask("Initialize transfer from " + String.valueOf(sourceSystem) + " to " + String.valueOf(targetSystem), sourceElements.size());
                        for (CDOTransferElement sourceElement : sourceElements) {
                            transfer.map(sourceElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (OperationCanceledException ex) {
                        throw new InterruptedException();
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }
}

