/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin.protocol;

import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServer;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServerRepository;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.server.internal.admin.protocol.CDOAdminServerProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryRepositoriesIndication
extends IndicationWithResponse {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryRepositoriesIndication.class);

    public QueryRepositoriesIndication(CDOAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)1);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        in.readBoolean();
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        CDOAdminServerProtocol protocol = (CDOAdminServerProtocol)this.getProtocol();
        CDOAdminServer admin = (CDOAdminServer)((Object)protocol.getInfraStructure());
        CDOAdminRepository[] repositories = admin.getRepositories();
        int size = repositories.length;
        if (TRACER.isEnabled()) {
            TRACER.format("Writing {0} repository infos...", new Object[]{size});
        }
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            CDOAdminServerRepository repository = (CDOAdminServerRepository)repositories[i];
            if (TRACER.isEnabled()) {
                TRACER.format("Writing repository info for {0}", new Object[]{repository.getName()});
            }
            repository.write(out);
            ++i;
        }
    }
}

