/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.ui.CDOAdapterFactoryContentProvider;
import org.eclipse.emf.cdo.internal.ui.CDOContentProvider;
import org.eclipse.emf.cdo.internal.ui.CDOViewerComparator;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOLabelProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.widgets.BaseDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractResourceSelectionDialog<INPUT>
extends BaseDialog<TreeViewer> {
    private final Set<URI> uris = new HashSet<URI>();
    private final boolean multi;
    private TreeViewer viewer;

    public AbstractResourceSelectionDialog(Shell shell, boolean multi, String title, String message, ImageDescriptor descriptor) {
        super(shell, 66800, title, message, OM.Activator.INSTANCE.getDialogSettings(), descriptor);
        this.multi = multi;
    }

    public final Set<URI> getURIs() {
        return this.uris;
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    protected abstract INPUT getInput();

    protected void createUI(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry());
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.viewer = new TreeViewer(parent, this.multi ? 2 : 4);
        this.viewer.getTree().setLayoutData((Object)UIUtil.createGridData());
        this.viewer.setContentProvider((IContentProvider)new ResourcesContentProvider(adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourcesLabelProvider((AdapterFactory)adapterFactory, (Viewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new CDOViewerComparator());
        this.viewer.setInput(this.getInput());
        this.viewer.addDoubleClickListener(e -> this.okPressed());
        this.viewer.addSelectionChangedListener(e -> this.selectionChanged());
        this.setCurrentViewer((Viewer)this.viewer);
        UIUtil.asyncExec((Display)parent.getDisplay(), () -> this.selectionChanged());
    }

    protected void selectionChanged() {
        this.uris.clear();
        ITreeSelection selection = ((TreeViewer)this.getCurrentViewer()).getStructuredSelection();
        for (Object object : selection) {
            if (!(object instanceof CDOResource)) continue;
            URI uri = ((CDOResource)object).getURI();
            this.uris.add(uri);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!this.uris.isEmpty());
        }
    }

    protected boolean elementHasChildren(Object object, Predicate<Object> defaultHasChildren) {
        return defaultHasChildren.test(object);
    }

    protected Object[] elementGetChildren(Object object, Function<Object, Object[]> defaultGetChildren) {
        return defaultGetChildren.apply(object);
    }

    protected Object elementGetParent(Object object, Function<Object, Object> defaultGetParent) {
        return defaultGetParent.apply(object);
    }

    protected String elementGetText(Object object, Function<Object, String> defaultGetText) {
        return defaultGetText.apply(object);
    }

    protected Image elementGetImage(Object object, Function<Object, Image> defaultGetImage) {
        return defaultGetImage.apply(object);
    }

    protected Color elementGetForeground(Object object, Function<Object, Color> defaultGetForeground) {
        return defaultGetForeground.apply(object);
    }

    private final class ResourcesContentProvider
    extends CDOContentProvider.ContextFree {
        private final ComposedAdapterFactory adapterFactory;
        private final CDOAdapterFactoryContentProvider delegate;

        public ResourcesContentProvider(ComposedAdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
            this.delegate = new CDOAdapterFactoryContentProvider((AdapterFactory)adapterFactory);
        }

        @Override
        public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
            super.inputChanged(newViewer, oldInput, newInput);
            this.delegate.inputChanged(newViewer, oldInput, newInput);
        }

        @Override
        public boolean hasChildren(Object object) {
            return AbstractResourceSelectionDialog.this.elementHasChildren(object, this::defaultHasChildren);
        }

        @Override
        public Object[] getChildren(Object object) {
            return AbstractResourceSelectionDialog.this.elementGetChildren(object, this::defaultGetChildren);
        }

        @Override
        public Object getParent(Object object) {
            return AbstractResourceSelectionDialog.this.elementGetParent(object, this::defaultGetParent);
        }

        @Override
        protected Object adapt(Object target, Object type) {
            return this.adapterFactory.adapt(target, type);
        }

        @Override
        protected Object[] modifyChildren(Object parent, Object[] children) {
            return children;
        }

        @Override
        protected ITreeContentProvider getContentProvider(Object object) {
            return this.delegate;
        }

        @Override
        protected RunnableViewerRefresh getViewerRefresh() {
            return this.delegate.getViewerRefresh();
        }

        private boolean defaultHasChildren(Object object) {
            if (object instanceof CDOView) {
                CDOView view = (CDOView)object;
                CDOResource rootResource = view.getRootResource();
                CDORevision revision = rootResource.cdoRevision();
                return CDORevisionUtil.hasChildRevisions((CDORevision)revision);
            }
            if (object instanceof CDOResourceFolder) {
                CDOResourceFolder folder = (CDOResourceFolder)object;
                CDORevision revision = folder.cdoRevision();
                return CDORevisionUtil.hasChildRevisions((CDORevision)revision);
            }
            if (object instanceof CDOResourceLeaf) {
                CDOResource resource;
                if (object instanceof CDOResource && (resource = (CDOResource)object).isRoot()) {
                    return !resource.getContents().isEmpty();
                }
                return false;
            }
            return super.hasChildren(object);
        }

        private Object[] defaultGetChildren(Object object) {
            if (object instanceof CDOView) {
                CDOView view = (CDOView)object;
                CDOResource rootResource = view.getRootResource();
                return super.getChildren(rootResource);
            }
            if (object instanceof CDOResourceFolder) {
                CDOResourceFolder folder = (CDOResourceFolder)object;
                return super.getChildren(folder);
            }
            if (object instanceof CDOResourceLeaf) {
                CDOResource resource;
                if (object instanceof CDOResource && (resource = (CDOResource)object).isRoot()) {
                    return super.getChildren(resource);
                }
                return new Object[0];
            }
            return super.getChildren(object);
        }

        private Object defaultGetParent(Object object) {
            if (object instanceof CDOResourceNode) {
                CDOResourceNode node = (CDOResourceNode)object;
                CDOResourceFolder folder = node.getFolder();
                if (folder == null) {
                    return node.cdoView();
                }
                return folder;
            }
            if (object instanceof CDOView) {
                return this.getInput();
            }
            return super.getParent(object);
        }
    }

    private final class ResourcesLabelProvider
    extends AdapterFactoryLabelProvider.ColorProvider {
        public ResourcesLabelProvider(AdapterFactory adapterFactory, Viewer viewer) {
            super(adapterFactory, viewer);
        }

        public String getText(Object object) {
            return AbstractResourceSelectionDialog.this.elementGetText(object, this::defaultGetText);
        }

        public Image getImage(Object object) {
            return AbstractResourceSelectionDialog.this.elementGetImage(object, this::defaultGetImage);
        }

        public Color getForeground(Object object) {
            return AbstractResourceSelectionDialog.this.elementGetForeground(object, this::defaultGetForeground);
        }

        private String defaultGetText(Object object) {
            if (object instanceof CDOView) {
                CDOView view = (CDOView)object;
                CDOSession session = view.getSession();
                Object repository = session.properties().get((Object)"org.eclipse.emf.cdo.explorer.repositories.CDORepository");
                if (repository != null) {
                    return repository.toString();
                }
                CDORepositoryInfo repositoryInfo = session.getRepositoryInfo();
                return repositoryInfo.getName();
            }
            return super.getText(object);
        }

        private Image defaultGetImage(Object object) {
            if (object instanceof CDOView) {
                return SharedIcons.getImage((String)"obj16/repo.gif");
            }
            return super.getImage(object);
        }

        private Color defaultGetForeground(Object object) {
            Color color;
            if (object instanceof ViewerUtil.Pending) {
                return ContainerItemProvider.pendingColor();
            }
            if (object instanceof CDOObject && (color = CDOLabelProvider.getColor((CDOObject)object)) != null) {
                return color;
            }
            return super.getForeground(object);
        }
    }
}

