/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.IOException;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.collection.Entity;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringCompressor;

public class EntityIndication
extends IndicationWithResponse {
    private int opcode;
    private String namespace;
    private String[] names;

    public EntityIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)-6);
    }

    @Override
    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.opcode = in.readVarInt();
        switch (this.opcode) {
            case 1: {
                this.namespace = this.readCompressedString(in);
                this.names = EntityIndication.readStrings(in);
                break;
            }
        }
    }

    @Override
    protected void responding(ExtendedDataOutputStream out) throws Exception {
        Entity.Store entityProvider = this.getEntityStore();
        if (entityProvider == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        StringCompressor compressor = this.getStringCompressor();
        switch (this.opcode) {
            case 1: {
                int result = 0;
                String[] stringArray = this.names;
                int n = this.names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    Entity entity = entityProvider.entity(this.namespace, name);
                    if (entity != null) {
                        out.writeBoolean(true);
                        entity.write((ExtendedDataOutput)out, compressor);
                        ++result;
                    } else {
                        out.writeBoolean(false);
                    }
                    ++n2;
                }
                out.writeVarInt(result);
                break;
            }
        }
    }

    protected Entity.Store getEntityStore() {
        return this.getProtocol().getEntityStore();
    }

    protected StringCompressor getStringCompressor() {
        return this.getProtocol().getStringCompressor();
    }

    private String readCompressedString(ExtendedDataInputStream in) throws IOException {
        StringCompressor compressor = this.getStringCompressor();
        if (compressor != null) {
            return compressor.read((ExtendedDataInput)in);
        }
        return in.readString();
    }

    private static String[] readStrings(ExtendedDataInputStream in) throws IOException {
        int length = in.readVarInt();
        String[] strings = new String[length];
        int i = 0;
        while (i < length) {
            strings[i] = in.readString();
            ++i;
        }
        return strings;
    }
}

