/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.wss;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.ee8.websocket.client.WebSocketClient;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.net4j.internal.ws.WSClientConnector;
import org.eclipse.net4j.util.StringUtil;

public class WSSClientConnector
extends WSClientConnector {
    @Override
    public String toString() {
        return MessageFormat.format("WSSClientConnector[{0}]", this.getURL());
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        if (!this.getServiceURI().getScheme().equals("wss")) {
            throw new IllegalArgumentException("Service Uri should have wss:// scheme");
        }
        SslContextFactory.Client sslContextFactory = WSSClientConnector.createSslContextFactory();
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        WebSocketClient securedClient = new WebSocketClient(httpClient);
        this.configureProxy(securedClient, "HTTPS");
        this.configureBasicAuthentication(securedClient);
        this.setClient(securedClient);
        this.ownedClient = true;
        super.doBeforeActivate();
    }

    private static SslContextFactory.Client createSslContextFactory() {
        URI uri;
        File file;
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        boolean trustAll = Boolean.getBoolean("org.eclipse.net4j.internal.wss.ssl.trustall");
        String eia = System.getProperty("org.eclipse.net4j.internal.wss.ssl.endpointIdentificationAlgorithm");
        String passphrase = System.getProperty("org.eclipse.net4j.internal.wss.ssl.passphrase");
        String trustURI = System.getProperty("org.eclipse.net4j.internal.wss.ssl.trust");
        String trustType = System.getProperty("org.eclipse.net4j.internal.wss.ssl.trust.type");
        String trustAlg = System.getProperty("org.eclipse.net4j.internal.wss.ssl.trust.manager.factory.algorithm");
        sslContextFactory.setTrustAll(trustAll);
        if ("null".equals(eia)) {
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
        } else if (!StringUtil.isEmpty((String)eia)) {
            sslContextFactory.setEndpointIdentificationAlgorithm(eia);
        }
        if (trustURI != null && (file = new File(uri = URI.create(trustURI))).exists()) {
            sslContextFactory.setTrustStoreResource(new PathResourceFactory().newResource(uri));
            sslContextFactory.setTrustStorePassword(passphrase);
            if (!StringUtil.isEmpty((String)trustType)) {
                sslContextFactory.setTrustStoreType(trustType);
            }
            if (!StringUtil.isEmpty((String)trustAlg)) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(trustAlg);
            }
        }
        return sslContextFactory;
    }
}

