/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.decorators;

import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.SelfAttachingContainerListener;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.UIUtil;

public class AvailableUpdatesDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private final ImageDescriptor updateModification = OM.getImageDescriptor("icons/overlay/UpdateModification.png");
    private final ImageDescriptor updateAddition = OM.getImageDescriptor("icons/overlay/UpdateAddition.png");
    private final ImageDescriptor updateRemoval = OM.getImageDescriptor("icons/overlay/UpdateRemoval.png");
    private final IListener assemblyManagerListener = new SelfAttachingContainerListener(){

        protected void notifyOtherEvent(IEvent event) {
            super.notifyOtherEvent(event);
            if (event instanceof IAssemblyDescriptor.UpdateStateChangedEvent) {
                IAssemblyDescriptor.UpdateStateChangedEvent e = (IAssemblyDescriptor.UpdateStateChangedEvent)event;
                IAssemblyDescriptor descriptor = e.getDescriptor();
                AvailableUpdatesDecorator.this.fireLabelEvent(descriptor, descriptor.getCheckout());
            } else if (event instanceof IAssemblyDescriptor.AvailableUpdatesChangedEvent) {
                IAssemblyDescriptor.AvailableUpdatesChangedEvent e = (IAssemblyDescriptor.AvailableUpdatesChangedEvent)event;
                Object[] modules = e.getDescriptor().getModules(true);
                AvailableUpdatesDecorator.this.fireLabelEvent(modules);
            }
        }
    };

    public AvailableUpdatesDecorator() {
        IAssemblyManager.INSTANCE.addListener(this.assemblyManagerListener);
    }

    public void dispose() {
        IAssemblyManager.INSTANCE.removeListener(this.assemblyManagerListener);
        super.dispose();
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IAssemblyDescriptor) {
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)element;
            if (descriptor.hasUpdatesAvailable()) {
                decoration.addOverlay(this.updateModification, 1);
            }
        } else if (element instanceof AssemblyModule) {
            IAssemblyDescriptor.Updates updates;
            AssemblyModule module = (AssemblyModule)element;
            String moduleName = module.getName();
            IAssemblyDescriptor descriptor = IAssemblyManager.INSTANCE.getDescriptor((EObject)module);
            if (descriptor != null && (updates = descriptor.getAvailableUpdates()) != null) {
                if (updates.getAdditions().containsKey(moduleName)) {
                    decoration.addOverlay(this.updateAddition, 1);
                } else if (updates.getRemovals().contains(moduleName)) {
                    decoration.addOverlay(this.updateRemoval, 1);
                } else {
                    AssemblyModule changedModule = (AssemblyModule)updates.getModifications().get(moduleName);
                    if (changedModule != null) {
                        decoration.addOverlay(this.updateModification, 1);
                        decoration.addSuffix(" \u2190 " + AvailableUpdatesDecorator.getSuffix(changedModule));
                    }
                }
            }
        }
    }

    private void fireLabelEvent(Object ... elements) {
        UIUtil.asyncExec(() -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements)));
    }

    public static String getSuffix(AssemblyModule module) {
        Object text = StringUtil.safe((Object)module.getVersion());
        Object baseline = CDOUtil.getAnnotation((ModelElement)module, (String)"http://www.eclipse.org/CDO/LM", (String)"baselineName");
        if (!StringUtil.isEmpty((String)baseline)) {
            String type = CDOUtil.getAnnotation((ModelElement)module, (String)"http://www.eclipse.org/CDO/LM", (String)"baselineType");
            if (!StringUtil.isEmpty((String)type)) {
                baseline = type + " " + (String)baseline;
            }
            text = (String)text + " [" + (String)baseline + "]";
        }
        return text;
    }
}

