/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.shared.common.info.ProductVersionHolder;

public final class FileMonitor
extends BaseMonitor {
    private File home;
    private ProductVersionHolder engineVersion;
    private static final Map<String, Void> securityProperties = new HashMap<String, Void>();

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintWriter log) {
        this.runWithState(properties, log);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File sr = new File(this.home, "derby.properties");
        if (!sr.exists()) {
            return null;
        }
        return new FileInputStream(sr);
    }

    @Override
    public Object getEnvironment() {
        return this.home;
    }

    private ThreadGroup createDaemonGroup() {
        ThreadGroup group = new ThreadGroup("derby.daemons");
        group.setDaemon(true);
        return group;
    }

    private boolean PBinitialize(boolean lite) {
        if (!lite) {
            this.daemonGroup = this.createDaemonGroup();
        }
        InputStream versionStream = this.getClass().getResourceAsStream("/org/apache/derby/info/engine/info.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(versionStream);
        String systemHome = System.getProperty("derby.system.home");
        if (systemHome != null) {
            this.home = new File(systemHome);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + systemHome + " does not represent a directory");
                    return false;
                }
            } else if (!lite) {
                try {
                    boolean created = false;
                    boolean bl = created = this.home.mkdir() || this.home.mkdirs();
                    if (created) {
                        FileUtil.limitAccessToOwner(this.home);
                    }
                }
                catch (IOException ioe) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    final boolean initialize(boolean lite) {
        return this.PBinitialize(lite);
    }

    @Override
    final Properties getDefaultModuleProperties() {
        return FileMonitor.super.getDefaultModuleProperties();
    }

    @Override
    public final String getJVMProperty(String key) {
        if (!key.startsWith("derby.")) {
            return this.PBgetJVMProperty(key);
        }
        return this.PBgetJVMProperty(key);
    }

    @Override
    public final synchronized Thread getDaemonThread(Runnable task, String name, boolean setMinPriority) {
        try {
            return FileMonitor.super.getDaemonThread(task, name, setMinPriority);
        }
        catch (IllegalThreadStateException e) {
            if (this.daemonGroup != null && this.daemonGroup.isDestroyed()) {
                this.daemonGroup = this.createDaemonGroup();
                return FileMonitor.super.getDaemonThread(task, name, setMinPriority);
            }
            throw e;
        }
    }

    @Override
    final InputStream applicationPropertiesStream() throws IOException {
        return this.PBapplicationPropertiesStream();
    }

    @Override
    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }

    static {
        securityProperties.put("derby.authentication.builtin.algorithm", null);
        securityProperties.put("derby.authentication.provider", null);
        securityProperties.put("derby.database.fullAccessUsers", null);
        securityProperties.put("derby.database.readOnlyAccessUsers", null);
        securityProperties.put("derby.database.sqlAuthorization", null);
        securityProperties.put("derby.connection.requireAuthentication", null);
        securityProperties.put("derby.database.defaultConnectionMode", null);
        securityProperties.put("derby.storage.useDefaultFilePermissions", null);
        securityProperties.put("derby.system.home", null);
    }
}

