/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.Executor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.ssl.SSLProperties;
import org.eclipse.net4j.tcp.ssl.SSLUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class SSLEngineManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, SSLEngineManager.class);
    private Executor executor;
    private SSLEngine sslEngine;
    private int handShakeTimeOut;
    private int handShakeWaitTime;
    private boolean handShakeComplete;
    private SSLEngineResult.HandshakeStatus handShakeStatus;
    private boolean needRehandShake;
    private ByteBuffer appSendBuf;
    private ByteBuffer appRecvBuf;
    private ByteBuffer packetSendBuf;
    private ByteBuffer packetRecvBuf;
    private SSLEngineResult engineResult;
    private Object readLock = new ReadLock();
    private Object writeLock = new WriteLock();

    public SSLEngineManager(boolean client, String host, int port, Executor executor) throws Exception {
        this.executor = executor;
        SSLProperties sslProperties = new SSLProperties(SSLUtil.getConfigFile());
        String protocol = sslProperties.getProtocol(SSLUtil.getDefaultProtocol());
        String keyPath = sslProperties.getKeyPath(SSLUtil.getDefaultKeyPath());
        String trustPath = sslProperties.getTrustPath(SSLUtil.getDefaultTrustPath());
        String passPhrase = sslProperties.getPassPhrase(SSLUtil.getDefaultPassPhrase());
        this.handShakeTimeOut = sslProperties.getHandShakeTimeOut(SSLUtil.getDefaultHandShakeTimeOut());
        this.handShakeWaitTime = sslProperties.getHandShakeWaitTime(SSLUtil.getDefaultHandShakeWaitTime());
        if (keyPath == null && !client || trustPath == null && client || passPhrase == null) {
            if (client) {
                throw new KeyStoreException("Trust Store[" + (trustPath != null) + "] or Pass Phrase[" + (passPhrase != null) + "] is not provided. [false] means it does not exist.");
            }
            throw new KeyStoreException("Key Store[" + (keyPath != null) + "] or Pass Phrase[" + (passPhrase != null) + "] is not provided. [false] means it does not exist.");
        }
        char[] pass = passPhrase.toCharArray();
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        boolean checkValidtyStatus = OMPlatform.INSTANCE.isProperty("check.validity.certificate", true);
        if (client) {
            KeyStore ksTrust = SSLEngineManager.createKeyStore(trustPath, pass, checkValidtyStatus);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ksTrust);
            trustManagers = tmf.getTrustManagers();
        } else {
            KeyStore ksKeys = SSLEngineManager.createKeyStore(keyPath, pass, checkValidtyStatus);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksKeys, pass);
            keyManagers = kmf.getKeyManagers();
        }
        SSLContext sslContext = SSLContext.getInstance(protocol);
        sslContext.init(keyManagers, trustManagers, null);
        this.sslEngine = sslContext.createSSLEngine(host, port);
        this.sslEngine.setUseClientMode(client);
        this.sslEngine.beginHandshake();
        SSLSession session = this.sslEngine.getSession();
        int applicationBufferSize = session.getApplicationBufferSize();
        this.appSendBuf = ByteBuffer.allocate(applicationBufferSize);
        this.appRecvBuf = ByteBuffer.allocate(applicationBufferSize);
        int packetBufferSize = session.getPacketBufferSize();
        this.packetSendBuf = ByteBuffer.allocate(packetBufferSize);
        this.packetRecvBuf = ByteBuffer.allocate(packetBufferSize);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public int getHandShakeWaitTime() {
        return this.handShakeWaitTime;
    }

    public ByteBuffer getAppSendBuf() {
        return this.appSendBuf;
    }

    public void setAppSendBuf(ByteBuffer appSendBuf) {
        this.appSendBuf = appSendBuf;
    }

    public ByteBuffer getAppRecvBuf() {
        return this.appRecvBuf;
    }

    public void setAppRecvBuf(ByteBuffer appRecvBuf) {
        this.appRecvBuf = appRecvBuf;
    }

    public ByteBuffer getPacketSendBuf() {
        return this.packetSendBuf;
    }

    public void setPacketSendBuf(ByteBuffer packetSendBuf) {
        this.packetSendBuf = packetSendBuf;
    }

    public ByteBuffer getPacketRecvBuf() {
        return this.packetRecvBuf;
    }

    public void setPacketRecvBuf(ByteBuffer packetRecvBuf) {
        this.packetRecvBuf = packetRecvBuf;
    }

    public synchronized void checkInitialHandshake(SocketChannel socketChannel) throws Exception {
        if (!this.handShakeComplete) {
            try {
                int counter = 0;
                while (!this.isHandshakeFinished() && counter <= this.handShakeTimeOut) {
                    this.performHandshake(socketChannel, this.needRehandShake);
                    int n = counter = this.handShakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP ? counter++ : 0;
                }
                if (!this.isHandshakeFinished() && counter == this.handShakeTimeOut) {
                    throw new SSLException("SSL handshake timeout");
                }
            }
            catch (Exception ex) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("SSL handshake incomplete.", (Throwable)ex);
                }
                try {
                    this.close();
                }
                catch (IOException ioex) {
                    OM.LOG.warn((Throwable)ioex);
                }
                throw ex;
            }
            this.handShakeComplete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(SocketChannel socketChannel) throws IOException {
        if (!this.handShakeComplete) {
            throw new SSLException("Handshake still not completed");
        }
        Object object = this.readLock;
        synchronized (object) {
            int readTextCount = this.appRecvBuf.position();
            do {
                if (this.sslEngine.isInboundDone()) {
                    if (readTextCount <= 0) return -1;
                    int n = readTextCount;
                    return n;
                }
                int count = this.handleRead(socketChannel);
                if (count <= 0 && this.packetRecvBuf.position() == 0) {
                    return count;
                }
                this.packetRecvBuf.flip();
                this.engineResult = this.sslEngine.unwrap(this.packetRecvBuf, this.appRecvBuf);
                this.packetRecvBuf.compact();
                switch (this.engineResult.getStatus()) {
                    case BUFFER_UNDERFLOW: {
                        break;
                    }
                    case BUFFER_OVERFLOW: {
                        if (!TRACER.isEnabled()) return 0;
                        TRACER.trace("Buffer overflow on read method.");
                        return 0;
                    }
                    case CLOSED: {
                        throw new ClosedChannelException();
                    }
                    default: {
                        readTextCount = this.appRecvBuf.position();
                    }
                }
            } while (this.engineResult.getStatus() != SSLEngineResult.Status.OK);
            if (!this.sslEngine.isInboundDone()) return readTextCount;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(SocketChannel socketChannel) throws IOException {
        if (!this.handShakeComplete) {
            throw new SSLException("Handshake still not completed");
        }
        Object object = this.writeLock;
        synchronized (object) {
            int writeCount = 0;
            int count = 0;
            int appSendBufSize = this.appSendBuf.position();
            do {
                this.appSendBuf.flip();
                this.engineResult = this.sslEngine.wrap(this.appSendBuf, this.packetSendBuf);
                this.appSendBuf.compact();
                switch (this.engineResult.getStatus()) {
                    case BUFFER_UNDERFLOW: {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Buffer Underflow happen on write method");
                        }
                        return -1;
                    }
                    case BUFFER_OVERFLOW: {
                        count = this.handleWrite(socketChannel);
                        writeCount += count;
                        break;
                    }
                    case CLOSED: {
                        throw new ClosedChannelException();
                    }
                    case OK: {
                        int bytesComsumed = this.engineResult.bytesConsumed();
                        appSendBufSize -= bytesComsumed;
                        count = this.handleWrite(socketChannel);
                        writeCount += count;
                        break;
                    }
                }
            } while (this.engineResult.getStatus() != SSLEngineResult.Status.OK);
            return writeCount;
        }
    }

    public int handleWrite(SocketChannel socketChannel) throws IOException {
        try {
            this.packetSendBuf.flip();
            int count = socketChannel.write(this.packetSendBuf);
            this.packetSendBuf.compact();
            if (count == -1) {
                throw new ClosedChannelException();
            }
            return count;
        }
        catch (ClosedChannelException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new ClosedChannelException();
        }
    }

    public int handleRead(SocketChannel socketChannel) throws IOException {
        try {
            int count = socketChannel.read(this.packetRecvBuf);
            if (count == -1) {
                throw new ClosedChannelException();
            }
            return count;
        }
        catch (ClosedChannelException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new ClosedChannelException();
        }
    }

    public void close() throws IOException {
        if (this.sslEngine != null) {
            this.sslEngine.closeOutbound();
        }
    }

    public void checkRehandShake(SocketChannel socket) throws Exception {
        this.handShakeStatus = this.engineResult.getHandshakeStatus();
        boolean bl = this.needRehandShake = this.handShakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.handShakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.handShakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP;
        if (this.needRehandShake) {
            this.handShakeComplete = false;
        }
        this.checkInitialHandshake(socket);
    }

    public boolean isHandshakeComplete() {
        return this.handShakeComplete;
    }

    private boolean isHandshakeFinished() {
        return this.handShakeStatus != null && this.handShakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private boolean performHandshake(SocketChannel socketChannel, boolean rehandShake) throws IOException {
        int nBytes = 0;
        if (!rehandShake) {
            this.handShakeStatus = this.sslEngine.getHandshakeStatus();
        }
        switch (this.handShakeStatus) {
            case NEED_WRAP: {
                this.appSendBuf.flip();
                this.engineResult = this.sslEngine.wrap(this.appSendBuf, this.packetSendBuf);
                this.handShakeStatus = this.engineResult.getHandshakeStatus();
                this.appSendBuf.compact();
                block7 : switch (this.engineResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        nBytes = this.handleWrite(socketChannel);
                        break;
                    }
                    case OK: {
                        while (this.packetSendBuf.position() > 0) {
                            nBytes = this.handleWrite(socketChannel);
                            if (nBytes == 0) break block7;
                        }
                        break;
                    }
                    default: {
                        if (!TRACER.isEnabled()) break;
                        TRACER.trace("Need Wrap Operation: cannot handle ssl result status [" + (Object)((Object)this.engineResult.getStatus()) + "]");
                    }
                }
                return true;
            }
            case NEED_UNWRAP: {
                nBytes = this.handleRead(socketChannel);
                this.packetRecvBuf.flip();
                this.engineResult = this.sslEngine.unwrap(this.packetRecvBuf, this.appRecvBuf);
                this.handShakeStatus = this.engineResult.getHandshakeStatus();
                this.packetRecvBuf.compact();
                if (this.engineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW && this.sslEngine.isInboundDone()) {
                    return false;
                }
                return this.engineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
            case NEED_TASK: {
                this.executeTasks();
                return true;
            }
            case NOT_HANDSHAKING: {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Not handshaking status occurs.");
                }
                throw new ClosedChannelException();
            }
            case FINISHED: {
                return false;
            }
        }
        return true;
    }

    private void executeTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            this.executor.execute(task);
            if (!TRACER.isEnabled()) continue;
            TRACER.trace("Scheduled task: " + task);
        }
    }

    private static KeyStore createKeyStore(String path, char[] password, boolean checkValidity) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream in = null;
        try {
            in = new URL(path).openStream();
            keyStore.load(in, password);
            if (checkValidity) {
                Enumeration<String> aliasesIter = keyStore.aliases();
                while (aliasesIter.hasMoreElements()) {
                    String alias = aliasesIter.nextElement();
                    Certificate cert = keyStore.getCertificate(alias);
                    if (!(cert instanceof X509Certificate)) continue;
                    ((X509Certificate)cert).checkValidity();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
        return keyStore;
    }

    private static final class ReadLock {
        private ReadLock() {
        }
    }

    private static final class WriteLock {
        private WriteLock() {
        }
    }
}

