/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.net4j.util.io.DelegatingOutputStream;

public class XOROutputStream
extends DelegatingOutputStream {
    private int[] key;
    private int index;

    public XOROutputStream(OutputStream out, int ... key) {
        super(out);
        this.key = key;
    }

    public int[] getKey() {
        return this.key;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.key != null && this.key.length != 0) {
            if (this.index == this.key.length) {
                this.index = 0;
            }
            b = b & 0xFF ^ this.key[this.index++] & 0xFF;
        }
        super.write(b);
    }
}

