/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class Graph {
    private Graph() {
    }

    public static <E> List<E> topologicalSort(List<E> elements, Function<E, Collection<E>> adjacence) {
        ArrayList result = new ArrayList();
        HashSet visited = new HashSet();
        for (E element : elements) {
            Graph.visit(element, adjacence, result, visited);
        }
        return result;
    }

    private static <E> void visit(E element, Function<E, Collection<E>> adjacence, List<E> result, Set<E> visited) {
        if (visited.add(element)) {
            Collection<E> adjacentElements = adjacence.apply(element);
            if (adjacentElements != null) {
                for (E adjacentElement : adjacentElements) {
                    Graph.visit(adjacentElement, adjacence, result, visited);
                }
            }
            result.add(element);
        }
    }
}

