/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public final class ContextOperationAuthorization {
    public static final String CONTEXT_PARAMETER = "context";
    private final EObject context;
    private final Map<String, String> operationIDToVeto = new HashMap<String, String>();

    private ContextOperationAuthorization(EObject context, String[] operationIDs, String[] vetoes) {
        this.context = context;
        int i = 0;
        while (i < vetoes.length) {
            this.operationIDToVeto.put(operationIDs[i], vetoes[i]);
            ++i;
        }
    }

    public ContextOperationAuthorization(String ... operationIDs) {
        this((EObject)null, operationIDs, new String[operationIDs.length]);
    }

    public ContextOperationAuthorization(EObject context, String ... operationIDs) {
        this(context, operationIDs, ContextOperationAuthorization.authorize(context, operationIDs));
    }

    public EObject getContext() {
        return this.context;
    }

    public Set<String> getOperationsIDs() {
        return Collections.unmodifiableSet(this.operationIDToVeto.keySet());
    }

    public String getVeto(String operationID) {
        return this.operationIDToVeto.get(operationID);
    }

    public boolean isDenied(String operationID) {
        return this.getVeto(operationID) != null;
    }

    public boolean isGranted(String operationID) {
        return !this.isDenied(operationID);
    }

    private static CDOSession getSessionSafe(EObject context) {
        try {
            return CDOUtil.getSession(context);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] authorize(EObject context, String ... operationIDs) {
        CDOSession session = ContextOperationAuthorization.getSessionSafe(context);
        if (session != null) {
            AuthorizableOperation[] operations = new AuthorizableOperation[operationIDs.length];
            int i = 0;
            while (i < operationIDs.length) {
                operations[i] = AuthorizableOperation.builder((String)operationIDs[i]).parameter(CONTEXT_PARAMETER, (Object)context).build();
                ++i;
            }
            return session.authorizeOperations(operations);
        }
        return new String[operationIDs.length];
    }

    public static EObject getContext(AuthorizableOperation operation) {
        Object context = operation.getParameter(CONTEXT_PARAMETER);
        if (context instanceof EObject) {
            return (EObject)context;
        }
        return null;
    }
}

