/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.server.ocl.CDOEnvironment;
import org.eclipse.emf.cdo.server.ocl.CDOEvaluationEnvironment;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.utilities.TypedElement;

abstract class CDOAdditionalOperation
extends AdapterImpl {
    private final CDOEnvironment env;
    private final String name;

    private CDOAdditionalOperation(CDOEnvironment env, String name) {
        this.env = env;
        this.name = name;
    }

    public final CDOEnvironment getEnv() {
        return this.env;
    }

    public final String getName() {
        return this.name;
    }

    protected abstract void register();

    protected abstract Object evaluate(CDOEvaluationEnvironment var1, Object var2, Object[] var3);

    protected EClassifier getResultType(EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
        EClassifier result = operation.getEType();
        return result != null ? result : (EClassifier)this.env.getOCLStandardLibrary().getOclVoid();
    }

    protected final EOperation createEOperation(EClassifier resultType) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        result.setName(this.getName());
        result.setEType(resultType);
        result.eAdapters().add((Object)this);
        return result;
    }

    protected final EOperation createEOperation(EClassifier resultType, String paramName, EClassifier paramType) {
        EOperation result = this.createEOperation(resultType);
        EParameter param = EcoreFactory.eINSTANCE.createEParameter();
        param.setName(paramName);
        param.setEType(paramType);
        result.getEParameters().add((Object)param);
        return result;
    }

    protected final EClassifier collectionType(CollectionKind kind, EClassifier elementType) {
        return (EClassifier)this.env.getTypeResolver().resolveCollectionType(kind, (Object)elementType);
    }

    static CDOAdditionalOperation getInstance(EOperation operation) {
        CDOAdditionalOperation result = null;
        if (operation.getName().startsWith("cdo")) {
            for (Object next : operation.eAdapters()) {
                if (!(next instanceof CDOAdditionalOperation)) continue;
                result = (CDOAdditionalOperation)((Object)next);
                break;
            }
        }
        return result;
    }

    static void registerOperations(CDOEnvironment env) {
        new AllProperContents(env).register();
        new MatchesAnyStringAttribute(env).register();
    }

    /* synthetic */ CDOAdditionalOperation(CDOEnvironment cDOEnvironment, String string, CDOAdditionalOperation cDOAdditionalOperation) {
        this(cDOEnvironment, string);
    }

    private static class AllProperContents
    extends CDOAdditionalOperation {
        private static final String NAME = "cdoAllProperContents";

        private AllProperContents(CDOEnvironment env) {
            super(env, NAME, null);
        }

        @Override
        protected void register() {
            CDOEnvironment env = this.getEnv();
            EClassifier oclAny = (EClassifier)env.getOCLStandardLibrary().getOclAny();
            EClassifier oclT = (EClassifier)env.getOCLStandardLibrary().getT();
            EClassifier resultType = this.collectionType(CollectionKind.COLLECTION_LITERAL, oclT);
            env.addHelperOperation(oclAny, this.createEOperation(resultType));
            env.addHelperOperation(oclAny, this.createEOperation(resultType, "type", (EClassifier)env.getOCLStandardLibrary().getOclType()));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected Object evaluate(CDOEvaluationEnvironment evalEnv, Object source, Object[] arguments) {
            block3: {
                result = new ArrayList<EObject>();
                iter = source instanceof Resource != false ? EcoreUtil.getAllProperContents((Resource)((Resource)source), (boolean)false) : (source instanceof EObject != false ? EcoreUtil.getAllProperContents((EObject)((EObject)source), (boolean)false) : Collections.emptyList().iterator());
                if (arguments.length != 1) ** GOTO lbl18
                typeFilter = (EClassifier)arguments[0];
                if (typeFilter == null) {
                    typeFilter = EcorePackage.Literals.EOBJECT;
                }
                while (iter.hasNext()) {
                    next = (EObject)iter.next();
                    if (next.eIsProxy() || !typeFilter.isInstance((Object)next)) continue;
                    result.add(next);
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    next = (EObject)iter.next();
                    if (next.eIsProxy()) continue;
                    result.add(next);
lbl18:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            return result;
        }

        @Override
        protected EClassifier getResultType(EClassifier owner, EOperation operation, List<? extends TypedElement<EClassifier>> args) {
            EClassifier elementType = args.isEmpty() ? (EClassifier)this.getEnv().getOCLStandardLibrary().getOclAny() : (EClassifier)((TypeType)args.get(0).getType()).getReferredType();
            return this.collectionType(CollectionKind.COLLECTION_LITERAL, elementType);
        }
    }

    private static class MatchesAnyStringAttribute
    extends CDOAdditionalOperation {
        private static final String NAME = "cdoMatches";
        private static final int CACHE_SIZE = 16;
        private Map<String, Matcher> matcherCache;
        private Map<EClass, List<EAttribute>> stringAttributes;

        private MatchesAnyStringAttribute(CDOEnvironment env) {
            super(env, NAME, null);
        }

        @Override
        protected void register() {
            CDOEnvironment env = this.getEnv();
            EClassifier oclAny = (EClassifier)env.getOCLStandardLibrary().getOclAny();
            env.addHelperOperation(oclAny, this.createEOperation((EClassifier)env.getOCLStandardLibrary().getBoolean(), "regex", (EClassifier)env.getOCLStandardLibrary().getString()));
        }

        @Override
        protected Object evaluate(CDOEvaluationEnvironment evalEnv, Object source, Object[] arguments) {
            boolean result = false;
            if (source instanceof EObject) {
                EObject object = (EObject)source;
                Matcher m = this.getMatcher((String)arguments[0]);
                for (EAttribute next : this.getStringAttributes(object.eClass())) {
                    if (!next.isMany()) {
                        String value = (String)object.eGet((EStructuralFeature)next);
                        result = value != null && m.reset(value).matches();
                    } else {
                        List valueList = (List)object.eGet((EStructuralFeature)next);
                        int i = 0;
                        while (!result && i < valueList.size()) {
                            String value = (String)valueList.get(i);
                            result = value != null && m.reset(value).matches();
                            ++i;
                        }
                    }
                    if (result) break;
                }
            }
            return result;
        }

        private Matcher getMatcher(String regex) {
            Matcher result;
            if (this.matcherCache == null) {
                this.matcherCache = new LinkedHashMap<String, Matcher>(16, 0.75f, true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, Matcher> eldest) {
                        return this.size() > 16;
                    }
                };
            }
            if ((result = this.matcherCache.get(regex)) == null) {
                result = Pattern.compile(regex).matcher("");
                this.matcherCache.put(regex, result);
            }
            return result;
        }

        private List<EAttribute> getStringAttributes(EClass eClass) {
            List<Object> result;
            if (this.stringAttributes == null) {
                this.stringAttributes = new HashMap<EClass, List<EAttribute>>();
            }
            if ((result = this.stringAttributes.get(eClass)) == null) {
                for (EAttribute next : eClass.getEAllAttributes()) {
                    EDataType type = next.getEAttributeType();
                    if (type == null || type.getInstanceClass() != String.class) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(next);
                }
                if (result == null) {
                    result = Collections.emptyList();
                }
                this.stringAttributes.put(eClass, result);
            }
            return result;
        }
    }
}

