/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.wss;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.net4j.internal.wss.WSSAcceptorFactory;
import org.eclipse.net4j.internal.wss.WSSConnectorFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.ws.IWSAcceptor;
import org.eclipse.net4j.ws.IWSConnector;
import org.eclipse.net4j.ws.WSUtil;

public final class WSSUtil {
    public static final String FACTORY_TYPE = "wss";

    private WSSUtil() {
    }

    public static void prepareContainer(IManagedContainer container) {
        container.registerFactory((IFactory)new WSSAcceptorFactory());
        container.registerFactory((IFactory)new WSSConnectorFactory());
    }

    public static IWSAcceptor getAcceptor(IManagedContainer container, String acceptorName) {
        return (IWSAcceptor)container.getElement("org.eclipse.net4j.acceptors", FACTORY_TYPE, acceptorName);
    }

    public static IWSConnector getConnector(IManagedContainer container, String description) {
        return (IWSConnector)container.getElement("org.eclipse.net4j.connectors", FACTORY_TYPE, description);
    }

    public static IWSConnector getConnector(IManagedContainer container, URI serviceURI, String acceptorName, String ... arguments) {
        String description = WSSUtil.getConnectorDescription(serviceURI, acceptorName, arguments);
        return WSSUtil.getConnector(container, description);
    }

    public static String getConnectorDescription(String serviceURI, String acceptorName, String ... arguments) throws URISyntaxException {
        return WSSUtil.getConnectorDescription(new URI(serviceURI), acceptorName, arguments);
    }

    public static String getConnectorDescription(URI serviceURI, String acceptorName, String ... arguments) {
        return WSUtil.getConnectorDescription(serviceURI, acceptorName, arguments);
    }
}

