/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.revision;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.util.CheckUtil;

public abstract class RevisionInfo {
    private static final int NO_RESULT = 0;
    private static final int POINTER_RESULT = 1;
    private static final int DETACHED_RESULT = 2;
    private static final int NORMAL_RESULT = 3;
    private CDOID id;
    private CDOBranchPoint requestedBranchPoint;
    private InternalCDORevision result;
    private SyntheticCDORevision synthetic;

    protected RevisionInfo(CDOID id, CDOBranchPoint requestedBranchPoint) {
        this.id = id;
        this.requestedBranchPoint = requestedBranchPoint;
    }

    protected RevisionInfo(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
        CheckUtil.checkArg((Object)requestedBranchPoint, (String)"requestedBranchPoint");
        this.id = in.readCDOID();
        this.requestedBranchPoint = requestedBranchPoint;
    }

    public abstract Type getType();

    public final CDOID getID() {
        return this.id;
    }

    public final CDOBranchPoint getRequestedBranchPoint() {
        return this.requestedBranchPoint;
    }

    public InternalCDORevision getResult() {
        return this.result;
    }

    public void setResult(InternalCDORevision result) {
        this.result = result;
    }

    public SyntheticCDORevision getSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(SyntheticCDORevision synthetic) {
        this.synthetic = synthetic;
    }

    public abstract boolean isLoadNeeded();

    public void write(CDODataOutput out) throws IOException {
        out.writeByte(this.getType().ordinal());
        out.writeCDOID(this.id);
    }

    public String toString() {
        return this.id.toString();
    }

    public String toLongString() {
        return MessageFormat.format("RevisionInfo.{0}[{1}, {2}]", this.getClass().getSimpleName(), this.id, this.requestedBranchPoint);
    }

    public static RevisionInfo read(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
        byte ordinal = in.readByte();
        Type type = Type.values()[ordinal];
        switch (type) {
            case AVAILABLE_NORMAL: {
                return new Available.Normal(in, requestedBranchPoint);
            }
            case AVAILABLE_POINTER: {
                return new Available.Pointer(in, requestedBranchPoint);
            }
            case AVAILABLE_DETACHED: {
                return new Available.Detached(in, requestedBranchPoint);
            }
            case MISSING: {
                return new Missing(in, requestedBranchPoint);
            }
        }
        throw new IOException("Invalid revision info type: " + (Object)((Object)type));
    }

    public void execute(InternalCDORevisionManager revisionManager, int referenceChunk) {
        SyntheticCDORevision[] synthetics = new SyntheticCDORevision[1];
        this.result = revisionManager.getRevision(this.id, this.requestedBranchPoint, referenceChunk, 0, true, synthetics);
        this.synthetic = synthetics[0];
    }

    @Deprecated
    public void writeResult(CDODataOutput out, int referenceChunk) throws IOException {
        this.writeResult(out, referenceChunk, null);
    }

    public void writeResult(CDODataOutput out, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        this.writeRevision(out, referenceChunk, securityContext);
        boolean writePointerTarget = this.synthetic instanceof PointerCDORevision && ((PointerCDORevision)this.synthetic).getTarget() != this.result;
        RevisionInfo.writeResult(out, this.synthetic, writePointerTarget, referenceChunk, securityContext);
    }

    public void readResult(CDODataInput in) throws IOException {
        this.readRevision(in);
        this.synthetic = (SyntheticCDORevision)RevisionInfo.readResult(in, this.id, this.requestedBranchPoint.getBranch(), this.result);
    }

    public void processResult(InternalCDORevisionManager revisionManager, List<CDORevision> results, SyntheticCDORevision[] synthetics, int i) {
        if (this.result != null) {
            this.result = (InternalCDORevision)revisionManager.internRevision(this.result);
        }
        if (results != null) {
            if (this.result instanceof DetachedCDORevision) {
                results.add(null);
            } else {
                results.add(this.result);
            }
        }
        if (this.synthetic != null) {
            PointerCDORevision pointer;
            CDOBranchVersion target;
            this.synthetic = (SyntheticCDORevision)revisionManager.internRevision(this.synthetic);
            if (this.synthetic instanceof PointerCDORevision && (target = (pointer = (PointerCDORevision)this.synthetic).getTarget()) != this.result && target instanceof InternalCDORevision) {
                revisionManager.internRevision((CDORevision)target);
            }
            if (synthetics != null) {
                synthetics[i] = this.synthetic;
            }
        }
    }

    @Deprecated
    protected void writeRevision(CDODataOutput out, int referenceChunk) throws IOException {
        this.writeRevision(out, referenceChunk, null);
    }

    protected void writeRevision(CDODataOutput out, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        out.writeCDORevision(this.result, referenceChunk, securityContext);
    }

    protected void readRevision(CDODataInput in) throws IOException {
        this.result = (InternalCDORevision)in.readCDORevision();
    }

    @Deprecated
    public static void writeResult(CDODataOutput out, InternalCDORevision revision, int referenceChunk) throws IOException {
        RevisionInfo.writeResult(out, revision, referenceChunk, null);
    }

    @Deprecated
    public static void writeResult(CDODataOutput out, InternalCDORevision revision, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        RevisionInfo.writeResult(out, revision, true, referenceChunk, securityContext);
    }

    public static void writeResult(CDODataOutput out, InternalCDORevision revision, boolean writePointerTarget, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
        if (revision == null) {
            out.writeByte(0);
        } else if (revision instanceof PointerCDORevision) {
            PointerCDORevision pointer = (PointerCDORevision)revision;
            out.writeByte(1);
            out.writeCDOClassifierRef((EClassifier)pointer.getEClass());
            out.writeXLong(pointer.getRevised());
            if (writePointerTarget) {
                CDOBranchVersion target = pointer.getTarget();
                if (target instanceof InternalCDORevision) {
                    RevisionInfo.writeResult(out, (InternalCDORevision)target, true, referenceChunk, securityContext);
                } else {
                    out.writeByte(0);
                }
            } else {
                out.writeByte(0);
            }
        } else if (revision instanceof DetachedCDORevision) {
            DetachedCDORevision detached = (DetachedCDORevision)revision;
            out.writeByte(2);
            out.writeCDOClassifierRef((EClassifier)detached.getEClass());
            out.writeXLong(detached.getTimeStamp());
            out.writeXLong(detached.getRevised());
            out.writeXInt(detached.getVersion());
        } else {
            out.writeByte(3);
            out.writeCDORevision(revision, referenceChunk, securityContext);
        }
    }

    private static InternalCDORevision readResult(CDODataInput in, CDOID id, CDOBranch branch, InternalCDORevision result) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                EClassifier classifier = in.readCDOClassifierRefAndResolve();
                long revised = in.readXLong();
                InternalCDORevision target = RevisionInfo.readResult(in, id, branch);
                if (target == null && result != null) {
                    target = result;
                }
                return new PointerCDORevision((EClass)classifier, id, branch, revised, target);
            }
            case 2: {
                EClassifier classifier = in.readCDOClassifierRefAndResolve();
                long timeStamp = in.readXLong();
                long revised = in.readXLong();
                int version = in.readXInt();
                return new DetachedCDORevision((EClass)classifier, id, branch, version, timeStamp, revised);
            }
            case 3: {
                return (InternalCDORevision)in.readCDORevision();
            }
        }
        throw new IllegalStateException("Invalid synthetic type: " + type);
    }

    public static InternalCDORevision readResult(CDODataInput in, CDOID id, CDOBranch branch) throws IOException {
        return RevisionInfo.readResult(in, id, branch, null);
    }

    @Deprecated
    protected void doWriteResult(CDODataOutput out, InternalCDORevision revision, int referenceChunk) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected InternalCDORevision doReadResult(CDODataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static abstract class Available
    extends RevisionInfo {
        private CDOBranchVersion availableBranchVersion;

        protected Available(CDOID id, CDOBranchPoint requestedBranchPoint, CDOBranchVersion availableBranchVersion) {
            super(id, requestedBranchPoint);
            this.availableBranchVersion = availableBranchVersion;
        }

        protected Available(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
            super(in, requestedBranchPoint);
            this.availableBranchVersion = in.readCDOBranchVersion();
        }

        public CDOBranchVersion getAvailableBranchVersion() {
            return this.availableBranchVersion;
        }

        public boolean isDirect() {
            return this.availableBranchVersion.getBranch() == this.getRequestedBranchPoint().getBranch();
        }

        @Override
        public boolean isLoadNeeded() {
            return !this.isDirect();
        }

        @Override
        public void write(CDODataOutput out) throws IOException {
            super.write(out);
            out.writeCDOBranchVersion(this.availableBranchVersion);
        }

        @Override
        protected void writeRevision(CDODataOutput out, int referenceChunk, CDOBranchPoint securityContext) throws IOException {
            InternalCDORevision result = this.getResult();
            if (result != null && result.getBranch() == this.availableBranchVersion.getBranch()) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                super.writeRevision(out, referenceChunk, securityContext);
            }
        }

        @Override
        protected void readRevision(CDODataInput in) throws IOException {
            boolean useAvailable = in.readBoolean();
            if (useAvailable) {
                this.setResult((InternalCDORevision)this.availableBranchVersion);
            } else {
                super.readRevision(in);
            }
        }

        public static class Detached
        extends Available {
            public Detached(CDOID id, CDOBranchPoint requestedBranchPoint, CDOBranchVersion availableBranchVersion) {
                super(id, requestedBranchPoint, availableBranchVersion);
            }

            private Detached(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
                super(in, requestedBranchPoint);
            }

            @Override
            public Type getType() {
                return Type.AVAILABLE_DETACHED;
            }

            @Override
            public void processResult(InternalCDORevisionManager revisionManager, List<CDORevision> results, SyntheticCDORevision[] synthetics, int i) {
                if (!this.isLoadNeeded()) {
                    this.setSynthetic((DetachedCDORevision)this.getAvailableBranchVersion());
                }
                super.processResult(revisionManager, results, synthetics, i);
            }
        }

        public static class Normal
        extends Available {
            public Normal(CDOID id, CDOBranchPoint requestedBranchPoint, CDOBranchVersion availableBranchVersion) {
                super(id, requestedBranchPoint, availableBranchVersion);
            }

            private Normal(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
                super(in, requestedBranchPoint);
            }

            @Override
            public Type getType() {
                return Type.AVAILABLE_NORMAL;
            }

            @Override
            public InternalCDORevision getResult() {
                CDOBranchVersion branchVersion;
                if (this.isDirect() && (branchVersion = this.getAvailableBranchVersion()) instanceof InternalCDORevision) {
                    return (InternalCDORevision)branchVersion;
                }
                return super.getResult();
            }

            @Override
            public void processResult(InternalCDORevisionManager revisionManager, List<CDORevision> results, SyntheticCDORevision[] synthetics, int i) {
                if (!this.isLoadNeeded()) {
                    this.setResult((InternalCDORevision)this.getAvailableBranchVersion());
                }
                super.processResult(revisionManager, results, synthetics, i);
            }
        }

        public static class Pointer
        extends Available {
            private CDOBranchVersion targetBranchVersion;
            private boolean hasTarget;

            public Pointer(CDOID id, CDOBranchPoint requestedBranchPoint, CDOBranchVersion availableBranchVersion, CDOBranchVersion targetBranchVersion) {
                super(id, requestedBranchPoint, availableBranchVersion);
                this.targetBranchVersion = targetBranchVersion;
                this.hasTarget = targetBranchVersion instanceof InternalCDORevision;
            }

            private Pointer(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
                super(in, requestedBranchPoint);
                if (in.readBoolean()) {
                    this.targetBranchVersion = in.readCDOBranchVersion();
                    this.hasTarget = in.readBoolean();
                }
            }

            public CDOBranchVersion getTargetBranchVersion() {
                return this.targetBranchVersion;
            }

            @Override
            public Type getType() {
                return Type.AVAILABLE_POINTER;
            }

            public boolean hasTarget() {
                return this.hasTarget;
            }

            @Override
            public boolean isLoadNeeded() {
                if (this.getRequestedBranchPoint().getBranch().isMainBranch()) {
                    return false;
                }
                return !this.isDirect() || !this.hasTarget();
            }

            @Override
            public void write(CDODataOutput out) throws IOException {
                super.write(out);
                if (this.targetBranchVersion != null) {
                    out.writeBoolean(true);
                    out.writeCDOBranchVersion(this.targetBranchVersion);
                    out.writeBoolean(this.hasTarget);
                } else {
                    out.writeBoolean(false);
                }
            }

            @Override
            public void processResult(InternalCDORevisionManager revisionManager, List<CDORevision> results, SyntheticCDORevision[] synthetics, int i) {
                if (!this.isLoadNeeded()) {
                    CDOBranchVersion target = this.getTargetBranchVersion();
                    if (target instanceof InternalCDORevision) {
                        this.setResult((InternalCDORevision)target);
                    }
                    this.setSynthetic((PointerCDORevision)this.getAvailableBranchVersion());
                }
                super.processResult(revisionManager, results, synthetics, i);
            }
        }
    }

    public static class Missing
    extends RevisionInfo {
        public Missing(CDOID id, CDOBranchPoint requestedBranchPoint) {
            super(id, requestedBranchPoint);
        }

        private Missing(CDODataInput in, CDOBranchPoint requestedBranchPoint) throws IOException {
            super(in, requestedBranchPoint);
        }

        @Override
        public Type getType() {
            return Type.MISSING;
        }

        @Override
        public boolean isLoadNeeded() {
            return true;
        }
    }

    public static enum Type {
        AVAILABLE_NORMAL,
        AVAILABLE_POINTER,
        AVAILABLE_DETACHED,
        MISSING;

    }
}

