/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.lissome;

import java.io.File;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeBrowserPage;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.db.Index;
import org.eclipse.emf.cdo.tests.config.impl.RepositoryConfig;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.io.IOUtil;

public class LissomeConfig
extends RepositoryConfig {
    public static final RepositoryConfig INSTANCE = new LissomeConfig();
    public static final String STORE_NAME = "Lissome";
    private static final long serialVersionUID = 1L;
    private static File reusableFolder;

    public LissomeConfig() {
        super(STORE_NAME);
        this.supportingAudits(true);
        this.supportingBranches(true);
    }

    protected String getStoreName() {
        return STORE_NAME;
    }

    protected boolean isOptimizing() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public boolean supportingExtRefs() {
        return false;
    }

    public IStore createStore(String repoName) {
        if (reusableFolder == null) {
            reusableFolder = this.getCurrentTest().createTempFolder("lissome_", "_test");
            IOUtil.delete((File)reusableFolder);
        }
        IOUtil.ERR().println("Lissome folder: " + String.valueOf(reusableFolder));
        boolean dropIfExists = !this.isRestarting();
        DataSource dataSource = Index.createDataSource((File)reusableFolder, (String)repoName, null);
        H2Adapter.createSchema((DataSource)dataSource, (String)repoName, (boolean)dropIfExists);
        if (dropIfExists) {
            new File(reusableFolder, repoName + ".properties").delete();
            new File(reusableFolder, repoName + ".journal").delete();
            new File(reusableFolder, repoName + ".vob").delete();
        }
        LissomeStore store = new LissomeStore();
        store.setFolder(reusableFolder);
        return store;
    }

    public void setUp() throws Exception {
        IPluginContainer.INSTANCE.registerFactory((IFactory)new LissomeBrowserPage.Factory());
        super.setUp();
    }
}

