/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.File;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.TMPUtil;
import org.eclipse.net4j.util.om.log.RollingLog;
import org.eclipse.net4j.util.tests.AbstractOMTest;
import org.eclipse.net4j.util.tests.TestListener2;

public class RollingLogTest
extends AbstractOMTest {
    private static final String MESSAGE = "Hello World";

    public void testAppend() throws Exception {
        TestListener2 propertiesListener = new TestListener2(RollingLog.PropertiesEvent.class);
        TestListener2 splitListener = new TestListener2(RollingLog.SplitEvent.class);
        RollingLog log = new RollingLog(TMPUtil.getTempName((String)"rollinglog").getAbsolutePath(), 1000L, false);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.addListener((IListener)propertiesListener);
        log.addListener((IListener)splitListener);
        log.activate();
        RollingLogTest.write(log, 3000);
        log.commit();
        RollingLogTest.assertEquals((int)9, (int)log.getFileNumber());
        RollingLogTest.assertEquals((int)9, (int)splitListener.getEvents().size());
        log.deactivate();
        RollingLogTest.assertEquals((int)1, (int)propertiesListener.getEvents().size());
        propertiesListener = new TestListener2(RollingLog.PropertiesEvent.class);
        splitListener = new TestListener2(RollingLog.SplitEvent.class);
        log = new RollingLog(log.getLogFile(), 1000L, true);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.addListener((IListener)propertiesListener);
        log.addListener((IListener)splitListener);
        log.activate();
        RollingLogTest.write(log, 3000);
        log.commit();
        RollingLogTest.assertEquals((int)19, (int)log.getFileNumber());
        RollingLogTest.assertEquals((int)10, (int)splitListener.getEvents().size());
        log.deactivate();
        RollingLogTest.assertEquals((int)2, (int)propertiesListener.getEvents().size());
    }

    public void testOverwrite() throws Exception {
        TestListener2 propertiesListener = new TestListener2(RollingLog.PropertiesEvent.class);
        TestListener2 splitListener = new TestListener2(RollingLog.SplitEvent.class);
        RollingLog log = new RollingLog(TMPUtil.getTempName((String)"rollinglog").getAbsolutePath(), 1000L, false);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.addListener((IListener)propertiesListener);
        log.addListener((IListener)splitListener);
        log.activate();
        RollingLogTest.write(log, 3000);
        log.commit();
        RollingLogTest.assertEquals((int)9, (int)log.getFileNumber());
        RollingLogTest.assertEquals((int)9, (int)splitListener.getEvents().size());
        log.deactivate();
        RollingLogTest.assertEquals((int)1, (int)propertiesListener.getEvents().size());
        propertiesListener = new TestListener2(RollingLog.PropertiesEvent.class);
        splitListener = new TestListener2(RollingLog.SplitEvent.class);
        log = new RollingLog(log.getLogFile(), 1000L, false);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.addListener((IListener)propertiesListener);
        log.addListener((IListener)splitListener);
        log.activate();
        RollingLogTest.write(log, 3000);
        log.commit();
        RollingLogTest.assertEquals((int)9, (int)log.getFileNumber());
        RollingLogTest.assertEquals((int)9, (int)splitListener.getEvents().size());
        log.deactivate();
        RollingLogTest.assertEquals((int)1, (int)propertiesListener.getEvents().size());
    }

    public void testRecover() throws Exception {
        RollingLog log = new RollingLog(TMPUtil.getTempName((String)"rollinglog").getAbsolutePath(), 1000L, false);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.activate();
        RollingLogTest.write(log, 3000);
        log.commit();
        log.deactivate();
        RollingLogTest.assertTrue(new File(log.getLogFile() + ".properties").delete());
        TestListener2 recoveryListener = new TestListener2(RollingLog.RecoveryEvent.class);
        TestListener2 propertiesListener = new TestListener2(RollingLog.PropertiesEvent.class);
        log = new RollingLog(log.getLogFile(), 1000L, true);
        log.setWriteBulk(false);
        log.setWriteInterval(0L);
        log.addListener((IListener)recoveryListener);
        log.addListener((IListener)propertiesListener);
        log.activate();
        RollingLogTest.assertEquals((int)19, (int)recoveryListener.getEvents().size());
        log.deactivate();
        RollingLogTest.assertEquals((int)2, (int)propertiesListener.getEvents().size());
    }

    private static void write(RollingLog log, int size) {
        int i = 0;
        while (i < size) {
            log.log(MESSAGE);
            i += MESSAGE.length();
        }
    }
}

