/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;

public class ChangeCredentialsRequest
extends CDOClientRequestWithMonitoring<Boolean> {
    static final ConcurrentMap<CDOSession, AtomicReference<char[]>> NEW_PASSWORD_RECEIVERS = new ConcurrentHashMap<CDOSession, AtomicReference<char[]>>();
    private final CredentialsUpdateOperation operation;
    private final AtomicReference<char[]> newPasswordReceiver;
    private final String userID;

    public ChangeCredentialsRequest(CDOClientProtocol protocol, AtomicReference<char[]> newPasswordReceiver) {
        super(protocol, (short)56);
        this.operation = CredentialsUpdateOperation.CHANGE_PASSWORD;
        this.newPasswordReceiver = newPasswordReceiver;
        this.userID = null;
    }

    public ChangeCredentialsRequest(CDOClientProtocol protocol, String userID) {
        super(protocol, (short)56);
        this.operation = CredentialsUpdateOperation.RESET_PASSWORD;
        this.newPasswordReceiver = null;
        this.userID = userID;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        if (this.newPasswordReceiver != null) {
            NEW_PASSWORD_RECEIVERS.put((CDOSession)this.getSession(), this.newPasswordReceiver);
        }
        out.writeEnum((Enum)this.operation);
        out.writeString(this.userID);
    }

    @Override
    protected Boolean confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        try {
            Boolean bl = in.readBoolean();
            return bl;
        }
        finally {
            NEW_PASSWORD_RECEIVERS.remove(this.getSession());
        }
    }
}

