/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;

public class H2Playground {
    public static void main(String[] args) throws Exception {
        String url = "jdbc:h2:./state/H2Playground";
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = DriverManager.getConnection(url, "sa", "");){
            Statement stmt = conn.createStatement();
            stmt.execute("DROP TABLE IF EXISTS teams");
            stmt.execute("CREATE TABLE teams (id VARCHAR(100) PRIMARY KEY, name VARCHAR(100), num_persons INT DEFAULT 0)");
            stmt.execute("INSERT INTO teams (id, name, num_persons) VALUES ('Alpha', 'Alpha', 0)");
            stmt.execute("INSERT INTO teams (id, name, num_persons) VALUES ('Beta', 'Beta', 0)");
            stmt.execute("INSERT INTO teams (id, name, num_persons) VALUES ('Gamma', 'Gamma', 0)");
            stmt.execute("DROP TABLE IF EXISTS persons");
            stmt.execute("CREATE TABLE persons (id INT PRIMARY KEY, name VARCHAR(100), team_id VARCHAR(100))");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (1, 'Alice-1', 'Alpha-1')");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (2, 'Bob-1', 'Alpha-1')");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (3, 'Charlie-1', 'Alpha-1')");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (4, 'Diana-0', NULL)");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (5, 'Eve-3', 'Gamma-3')");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (6, 'Frank-3', 'Gamma-3')");
            stmt.execute("INSERT INTO persons (id, name, team_id) VALUES (7, 'Grace-3', 'Gamma-3')");
            System.out.println("LOCATE:");
            H2Playground.print(stmt, "SELECT name, LOCATE('-', name) pos FROM persons");
            stmt.execute("UPDATE teams SET num_persons = (SELECT COUNT(*) FROM persons WHERE persons.team_id LIKE teams.id || '-%')");
            System.out.println("Teams:");
            H2Playground.print(stmt, "SELECT * FROM teams");
            System.out.println("Persons:");
            H2Playground.print(stmt, "SELECT * FROM persons");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void print(Statement stmt, String sql) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet rs = stmt.executeQuery(sql);){
            H2Playground.print(rs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void print(ResultSet rs) throws Exception {
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            int i = 1;
            while (i <= columnCount) {
                if (i > 1) {
                    System.out.print(", ");
                }
                String columnName = rs.getMetaData().getColumnName(i).toLowerCase();
                Object value = rs.getObject(i);
                System.out.print(columnName + "=" + String.valueOf(value));
                ++i;
            }
            System.out.println();
        }
        System.out.println();
    }
}

