/*
 * Copyright 2008-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.mongodb.client.model;

/**
 * Indicates which document to return, the original document before change or the document after the change
 *
 * @mongodb.driver.manual reference/command/findAndModify findAndModify
 * @since 3.0
 */
public enum ReturnDocument {
    /**
     * Indicates to return the document before the update, replacement, or insert occurred.
     */
    BEFORE,
    /**
     * Indicates to return the document after the update, replacement, or insert occurred.
     */
    AFTER
}
