/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.mapping.CoreTypeMappings;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class StringIDHandler
extends Lifecycle
implements IIDHandler {
    public static final Set<CDOID.ObjectType> OBJECT_ID_TYPES = Collections.singleton(CDOID.ObjectType.STRING);
    public static final CDOID MIN = CDOID.NULL;
    public static final CDOID MAX = StringIDHandler.create(Long.toString(Long.MAX_VALUE));
    private DBStore store;
    private long lastObjectID = 0L;
    private long nextLocalObjectID = Long.MAX_VALUE;

    public StringIDHandler(DBStore store) {
        this.store = store;
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public int compare(CDOID id1, CDOID id2) {
        if (id1.getType() == CDOID.Type.OBJECT && id2.getType() == CDOID.Type.OBJECT) {
            return Long.valueOf(StringIDHandler.value(id1)).compareTo(Long.valueOf(StringIDHandler.value(id2)));
        }
        return id1.compareTo((Object)id2);
    }

    @Override
    public DBType getDBType() {
        return DBType.VARCHAR;
    }

    @Override
    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return OBJECT_ID_TYPES;
    }

    @Override
    public CDOID createCDOID(String val) {
        return StringIDHandler.create(val);
    }

    @Override
    public synchronized CDOID getLastObjectID() {
        return CDOIDUtil.createString((String)("" + this.lastObjectID));
    }

    @Override
    public synchronized void setLastObjectID(CDOID lastObjectID) {
        this.lastObjectID = Long.parseLong(StringIDHandler.value(lastObjectID));
    }

    @Override
    public void adjustLastObjectID(CDOID maxID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized CDOID getNextLocalObjectID() {
        return CDOIDUtil.createString((String)("" + this.nextLocalObjectID));
    }

    @Override
    public synchronized void setNextLocalObjectID(CDOID nextLocalObjectID) {
        this.nextLocalObjectID = Long.parseLong(StringIDHandler.value(nextLocalObjectID));
    }

    @Override
    public synchronized CDOID getNextCDOID(CDORevision revision) {
        if (revision.getBranch().isLocal()) {
            return CDOIDUtil.createString((String)("" + this.nextLocalObjectID--));
        }
        return CDOIDUtil.createString((String)("" + ++this.lastObjectID));
    }

    @Override
    @Deprecated
    public boolean isLocalCDOID(CDOID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITypeMapping getObjectTypeMapping() {
        return new CoreTypeMappings.TMObject();
    }

    @Override
    public void appendCDOID(StringBuilder builder, CDOID id) {
        builder.append("'");
        builder.append(StringIDHandler.value(id));
        builder.append("'");
    }

    @Override
    public void setCDOIDRaw(PreparedStatement stmt, int column, Object rawID) throws SQLException {
        stmt.setString(column, (String)rawID);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id) throws SQLException {
        this.setCDOID(stmt, column, id, -1L);
    }

    @Override
    public void setCDOID(PreparedStatement stmt, int column, CDOID id, long commitTime) throws SQLException {
        String value = StringIDHandler.value(id);
        stmt.setString(column, value == null || value.length() == 0 ? "0" : value);
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, int column) throws SQLException {
        String id = resultSet.getString(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return StringIDHandler.create(id);
    }

    @Override
    public CDOID getCDOID(ResultSet resultSet, String name) throws SQLException {
        String id = resultSet.getString(name);
        if (resultSet.wasNull()) {
            return null;
        }
        return StringIDHandler.create(id);
    }

    @Override
    public String getStringValue(ResultSet resultSet, int column) throws SQLException {
        String id = resultSet.getString(column);
        if (resultSet.wasNull()) {
            return "null";
        }
        return String.valueOf('\'') + id + '\'';
    }

    @Override
    public CDOID getMinCDOID() {
        return MIN;
    }

    @Override
    public CDOID getMaxCDOID() {
        return MAX;
    }

    @Override
    public CDOID mapURI(IDBStoreAccessor accessor, String uri, long commitTime) {
        return StringIDHandler.create(uri);
    }

    @Override
    public String unmapURI(IDBStoreAccessor accessor, CDOID id) {
        return StringIDHandler.value(id);
    }

    @Override
    public boolean deleteURIMapping(Statement statement, String uri) {
        return false;
    }

    @Override
    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
    }

    @Override
    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
    }

    private static CDOID create(String id) {
        if (id == null) {
            return null;
        }
        int length = id.length();
        if (length == 0) {
            return null;
        }
        char firstChar = id.charAt(0);
        if (length == 1 && firstChar == '0') {
            return null;
        }
        if (Character.isDigit(firstChar)) {
            long value = Long.parseLong(id);
            if (value < 0L) {
                throw new IllegalArgumentException("Illegal ID value: " + id);
            }
            return CDOIDUtil.createString((String)id);
        }
        return CDOIDUtil.createExternal((String)id);
    }

    private static String value(CDOID id) {
        return CDOIDUtil.getString((CDOID)id);
    }
}

