/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionInterner;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.CacheEvictionEvent;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.CleanableReferenceQueue;

public abstract class AbstractCDORevisionCache
extends Lifecycle
implements InternalCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, AbstractCDORevisionCache.class);
    private static boolean disableGC;
    private static boolean warnAboutDeprecation;
    @ReflectUtil.ExcludeFromDump
    private final CleanableReferenceQueue<InternalCDORevision> referenceQueue = new CleanableReferenceQueue<InternalCDORevision>(){

        protected Reference<InternalCDORevision> createReference(InternalCDORevision revision) {
            return AbstractCDORevisionCache.this.createReference(revision);
        }

        protected void cleanReference(Reference<? extends InternalCDORevision> reference) {
            AbstractCDORevisionCache.this.cleanReference(reference);
        }
    };
    private CDOBranchManager branchManager;
    private String name;

    static {
        warnAboutDeprecation = true;
    }

    public AbstractCDORevisionCache() {
        this.setPollMillis(60000L);
        this.setMaxWorkPerPoll(-1);
    }

    public CDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    public void setBranchManager(CDOBranchManager branchManager) {
        this.branchManager = branchManager;
    }

    protected final void checkBranch(CDOBranch branch) {
        CDOBranchManager actualBranchManager;
        if (this.branchManager != null && (actualBranchManager = branch.getBranchManager()) != this.branchManager) {
            throw new IllegalArgumentException("Wrong branch manager: " + actualBranchManager + "; expected: " + this.branchManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getPollMillis() {
        return this.referenceQueue.getPollMillis();
    }

    public void setPollMillis(long pollMillis) {
        this.referenceQueue.setPollMillis(pollMillis);
    }

    public int getMaxWorkPerPoll() {
        return this.referenceQueue.getMaxWorkPerPoll();
    }

    public void setMaxWorkPerPoll(int maxWorkPerPoll) {
        this.referenceQueue.setMaxWorkPerPoll(maxWorkPerPoll);
    }

    @Override
    public List<CDORevision> getCurrentRevisions() {
        ArrayList<CDORevision> currentRevisions = new ArrayList<CDORevision>();
        this.forEachCurrentRevision(r -> {
            boolean bl = currentRevisions.add((CDORevision)r);
        });
        return currentRevisions;
    }

    @Override
    public void forEachValidRevision(CDOBranchPoint branchPoint, boolean considerBranchBases, Consumer<CDORevision> consumer) {
        this.checkBranch(branchPoint.getBranch());
        this.forEachRevision(r -> CDOBranchUtil.forEachBranchPoint(branchPoint, considerBranchBases, bp -> {
            if (r.isValid((CDOBranchPoint)bp)) {
                consumer.accept((CDORevision)r);
                return false;
            }
            return true;
        }));
    }

    @Override
    public final CDORevision removeRevision(CDOID id, CDOBranchVersion branchVersion) {
        this.referenceQueue.clean();
        return this.doRemoveRevision(id, branchVersion);
    }

    protected abstract CDORevision doRemoveRevision(CDOID var1, CDOBranchVersion var2);

    protected void doDeactivate() throws Exception {
        this.clear();
        super.doDeactivate();
    }

    public String toString() {
        return this.formatName("CDORevisionCache");
    }

    private String formatName(String prefix) {
        return String.valueOf(prefix) + (this.name == null ? "" : "-" + this.name);
    }

    protected Reference<InternalCDORevision> createReference(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision {0} to {1}", new Object[]{revision, this});
        }
        if (disableGC) {
            return this.createStrongReference(revision);
        }
        return new CacheSoftReference((InternalCDORevision)revision, (ReferenceQueue<InternalCDORevision>)this.referenceQueue);
    }

    private Reference<InternalCDORevision> createStrongReference(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding revision {0} to {1} (STRONGLY REFERENCED)", new Object[]{revision, this});
        }
        return new CacheStrongReference((InternalCDORevision)revision);
    }

    protected void cleanReference(Reference<? extends InternalCDORevision> reference) {
        IListener[] listeners;
        int version;
        CDOBranch branch;
        CDORevisionKey key = (CDORevisionKey)((Object)reference);
        CDOID id = key.getID();
        InternalCDORevision revision = (InternalCDORevision)this.removeRevision(id, (branch = key.getBranch()).getVersion(version = key.getVersion()));
        if (revision != null) {
            key = revision;
        }
        if ((listeners = this.getListeners()).length != 0) {
            this.fireEvent(new CacheEvictionEvent(this, key), listeners);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Evicted {0} from {1}", new Object[]{key, this});
        }
    }

    @Override
    @Deprecated
    public void addRevision(CDORevision revision) {
        AbstractCDORevisionCache.addRevision(revision, this);
    }

    static void addRevision(CDORevision revision, CDORevisionInterner interner) {
        if (warnAboutDeprecation) {
            warnAboutDeprecation = false;
            OM.LOG.warn("As of CDO 4.15 use internRevision() instead of addRevision()");
        }
        interner.internRevision(revision);
    }

    private static final class CacheSoftReference
    extends SoftReference<InternalCDORevision>
    implements CDORevisionKey {
        private final CDOID id;
        private final CDOBranch branch;
        private final int version;

        public CacheSoftReference(InternalCDORevision revision, ReferenceQueue<InternalCDORevision> queue) {
            super(revision, queue);
            this.id = revision.getID();
            this.branch = revision.getBranch();
            this.version = revision.getVersion();
        }

        @Override
        public CDOID getID() {
            return this.id;
        }

        @Override
        public CDOBranch getBranch() {
            return this.branch;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}v{2}", this.getID(), this.getBranch().getID(), this.getVersion());
        }
    }

    private static final class CacheStrongReference
    extends SoftReference<InternalCDORevision>
    implements CDORevisionKey {
        private final CDOID id;
        private final CDOBranch branch;
        private final int version;

        public CacheStrongReference(InternalCDORevision revision) {
            super(revision);
            this.id = revision.getID();
            this.branch = revision.getBranch();
            this.version = revision.getVersion();
        }

        @Override
        public CDOID getID() {
            return this.id;
        }

        @Override
        public CDOBranch getBranch() {
            return this.branch;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return MessageFormat.format("{0}:{1}v{2}", this.getID(), this.getBranch().getID(), this.getVersion());
        }
    }
}

