/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EntryControlAdvisor {
    private static final String ADVISOR_KEY = "net4j.entryControlAdvisor";

    public final Control createControl(Composite parent, ControlConfig config) {
        Control control = this.doCreateControl(parent, config);
        control.setData(ADVISOR_KEY, (Object)this);
        return control;
    }

    protected Control doCreateControl(Composite parent, ControlConfig config) {
        Text text = new Text(parent, 514);
        text.addModifyListener(e -> this.processModifyEvent((Control)text, config));
        text.addKeyListener(KeyListener.keyPressedAdapter(e -> this.processKeyEvent((Control)text, config, (KeyEvent)e)));
        return text;
    }

    public String getEntry(Control control) {
        return ((Text)control).getText();
    }

    public void setEntry(Control control, String entry) {
        Text text = (Text)control;
        text.setText(entry);
        text.setSelection(entry.length());
    }

    public void renderHTML(Control control, StringBuilder html) {
        String entry = this.getEntry(control);
        entry = entry.replace("\n", "<br>");
        html.append("<p>");
        html.append(entry);
        html.append("</p>");
    }

    protected final void processModifyEvent(Control control, ControlConfig config) {
        Consumer<Control> modifyHandler = config.getModifyHandler();
        if (modifyHandler != null) {
            modifyHandler.accept(control);
        }
    }

    protected final void processKeyEvent(Control control, ControlConfig config, KeyEvent e) {
        Predicate<KeyEvent> okDetector;
        Consumer<Control> okHandler = config.getOkHandler();
        if (okHandler != null && (okDetector = config.getOkDetector()) != null && okDetector.test(e)) {
            okHandler.accept(control);
            e.doit = false;
        }
    }

    public static EntryControlAdvisor getAdvisor(Control control) {
        return (EntryControlAdvisor)control.getData(ADVISOR_KEY);
    }

    public static final class ControlConfig {
        public static final Predicate<KeyEvent> DEFAULT_OK_DETECTOR = e -> (e.keyCode == 13 || e.keyCode == 0x1000050) && (e.stateMask & SWT.MODIFIER_MASK) == 0;
        private Predicate<KeyEvent> okDetector = DEFAULT_OK_DETECTOR;
        private Consumer<Control> okHandler;
        private Consumer<Control> modifyHandler;

        public ControlConfig() {
        }

        public ControlConfig(ControlConfig source) {
            this.okDetector = source.okDetector;
            this.okHandler = source.okHandler;
            this.modifyHandler = source.modifyHandler;
        }

        public Predicate<KeyEvent> getOkDetector() {
            return this.okDetector;
        }

        public void setOkDetector(Predicate<KeyEvent> okDetector) {
            this.okDetector = okDetector;
        }

        public Consumer<Control> getOkHandler() {
            return this.okHandler;
        }

        public void setOkHandler(Consumer<Control> okHandler) {
            this.okHandler = okHandler;
        }

        public Consumer<Control> getModifyHandler() {
            return this.modifyHandler;
        }

        public void setModifyHandler(Consumer<Control> modifyHandler) {
            this.modifyHandler = modifyHandler;
        }
    }

    public static class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.ui.entryControlAdvisors";
        public static final String DEFAULT_TYPE = "default";

        protected Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public Factory() {
            this(DEFAULT_TYPE);
        }

        public EntryControlAdvisor create(String description) throws ProductCreationException {
            return new EntryControlAdvisor();
        }
    }
}

