/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class ComboAutoCompleter
implements ModifyListener {
    private ComboViewer viewer;

    public ComboAutoCompleter(ComboViewer viewer) {
        this.viewer = viewer;
    }

    public final ComboViewer getViewer() {
        return this.viewer;
    }

    public final void modifyText(ModifyEvent e) {
        String text = this.getText();
        Object foundElement = this.findShortestLabel(text);
        if (foundElement != null) {
            this.setSelection(new StructuredSelection(foundElement));
        }
    }

    protected void setSelection(StructuredSelection selection) {
        this.viewer.setSelection((ISelection)selection);
    }

    private Object findShortestLabel(String prefix) {
        Object foundElement = null;
        String shortestLabel = null;
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.viewer.getContentProvider();
        Object[] objectArray = contentProvider.getElements(this.viewer.getInput());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            String label = labelProvider.getText(element);
            if (label.startsWith(prefix) && (shortestLabel == null || label.length() < shortestLabel.length())) {
                shortestLabel = label;
                foundElement = element;
            }
            ++n2;
        }
        return foundElement;
    }

    private String getText() {
        return this.viewer.getCombo().getText();
    }

    public static void attach(ComboViewer viewer, ComboAutoCompleter completer) {
        viewer.getCombo().addModifyListener((ModifyListener)completer);
    }

    public static void attach(ComboViewer viewer) {
        viewer.getCombo().addModifyListener((ModifyListener)new ComboAutoCompleter(viewer));
    }
}

