/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.resources.CDOCheckoutFileSystem;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.StringUtil;

public class CDOCheckoutFileStore
extends FileStore {
    private static final String SLASH = CDOURIUtil.SEGMENT_SEPARATOR;
    private static final String[] NO_CHILDREN = new String[0];
    private final CDOCheckout checkout;
    private final String path;
    private final boolean shallowTimeStamp;

    public CDOCheckoutFileStore(CDOCheckout checkout, String path, boolean shallowTimeStamp) {
        this.checkout = checkout;
        this.path = CDOURIUtil.sanitizePath((String)path);
        this.shallowTimeStamp = shallowTimeStamp;
    }

    public final CDOCheckout getCheckout() {
        return this.checkout;
    }

    public final String getPath() {
        return this.path;
    }

    public IFileStore getParent() {
        if (this.isRoot()) {
            return null;
        }
        int lastSlash = this.path.lastIndexOf(SLASH);
        if (lastSlash != -1) {
            return new CDOCheckoutFileStore(this.checkout, this.path.substring(0, lastSlash), this.shallowTimeStamp);
        }
        return new CDOCheckoutFileStore(this.checkout, SLASH, this.shallowTimeStamp);
    }

    public String getName() {
        if (this.isRoot()) {
            return "";
        }
        int lastSlash = this.path.lastIndexOf(SLASH);
        if (lastSlash != -1) {
            return this.path.substring(lastSlash + 1);
        }
        return this.path;
    }

    public URI toURI() {
        return CDOCheckoutFileSystem.createURI(this.checkout, this.path, this.shallowTimeStamp);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        CDOResourceNode node = CDOCheckoutFileStore.getNode(this.checkout, this.path);
        if (node == null) {
            FileInfo info = this.createFileInfo(false);
            info.setExists(false);
            return info;
        }
        boolean root = node.isRoot();
        boolean folder = root || node instanceof CDOResourceFolder;
        boolean deepTimeStamp = !root && node instanceof CDOResource && !this.shallowTimeStamp;
        FileInfo info = this.createFileInfo(deepTimeStamp);
        info.setExists(true);
        info.setDirectory(folder);
        if (!deepTimeStamp) {
            info.setLastModified(CDOCheckoutFileStore.getTimeStamp(node, deepTimeStamp));
        }
        if (node instanceof CDOFileResource) {
            CDOFileResource file = (CDOFileResource)node;
            CDOLob contents = file.getContents();
            info.setLength(contents == null ? 0L : contents.getSize());
        }
        return info;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        CDOResourceNode node = CDOCheckoutFileStore.getNode(this.checkout, this.path);
        EList<? extends EObject> children = this.getChildren(node);
        if (children != null) {
            int size = children.size();
            String[] names = new String[size];
            int i = 0;
            while (i < size) {
                CDOResourceNode child = (CDOResourceNode)children.get(i);
                names[i] = child.getName();
                ++i;
            }
            return names;
        }
        return NO_CHILDREN;
    }

    public IFileStore getChild(String name) {
        String childPath = String.valueOf(this.path) + (this.isRoot() ? name : String.valueOf(SLASH) + name);
        return new CDOCheckoutFileStore(this.checkout, childPath, this.shallowTimeStamp);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        CDOResourceNode node = CDOCheckoutFileStore.getNode(this.checkout, this.path);
        if (node == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.cdo.explorer", 269, "Resource does not exist: " + this.path, null));
        }
        if (node instanceof CDOResourceFolder) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.cdo.explorer", 276, "Resource is a folder: " + this.path, null));
        }
        CDOResourceLeaf leaf = (CDOResourceLeaf)node;
        try {
            return CDOUtil.openInputStream((CDOResourceLeaf)leaf);
        }
        catch (IOException ex) {
            OM.BUNDLE.coreException((Throwable)ex);
            return null;
        }
    }

    private boolean isRoot() {
        return SLASH.equals(this.path);
    }

    private FileInfo createFileInfo(boolean deepTimeStamp) {
        LazyTimeStampFileInfo info = deepTimeStamp ? new LazyTimeStampFileInfo(this.checkout, this.path, this.getName()) : new FileInfo(this.getName());
        info.setLength(0L);
        info.setAttribute(0x400000, true);
        info.setAttribute(0x2000000, true);
        info.setAttribute(0x10000000, true);
        info.setAttribute(0x800000, false);
        info.setAttribute(0x4000000, false);
        info.setAttribute(0x20000000, false);
        info.setAttribute(0x1000000, false);
        info.setAttribute(0x8000000, false);
        info.setAttribute(0x40000000, false);
        return info;
    }

    private EList<? extends EObject> getChildren(CDOResourceNode node) {
        if (node instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)node;
            return folder.getNodes();
        }
        if (node != null && node.isRoot()) {
            return ((CDOResource)node).getContents();
        }
        return null;
    }

    private static long getTimeStamp(CDOResourceNode node, boolean deepTimeStamp) {
        long timeStamp = node.cdoRevision(true).getTimeStamp();
        if (deepTimeStamp) {
            Resource resource = (Resource)node;
            TreeIterator it = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
            while (it.hasNext()) {
                CDOObject object = CDOUtil.getCDOObject((EObject)((EObject)it.next()));
                timeStamp = Math.max(timeStamp, object.cdoRevision(true).getTimeStamp());
            }
        }
        return timeStamp;
    }

    private static CDOResourceNode getNode(CDOCheckout checkout, String path) {
        CDOView view = checkout.getView();
        if (view != null) {
            try {
                if (StringUtil.isEmpty((String)path)) {
                    return view.getRootResource();
                }
                return view.getResourceNode(path);
            }
            catch (CDOResourceNodeNotFoundException cDOResourceNodeNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class LazyTimeStampFileInfo
    extends FileInfo {
        private final CDOCheckout checkout;
        private final String path;
        private boolean timeStampInitialized;

        public LazyTimeStampFileInfo(CDOCheckout checkout, String path, String name) {
            super(name);
            this.checkout = checkout;
            this.path = path;
        }

        public long getLastModified() {
            if (!this.timeStampInitialized) {
                super.setLastModified(CDOCheckoutFileStore.getTimeStamp(CDOCheckoutFileStore.getNode(this.checkout, this.path), true));
            }
            return super.getLastModified();
        }

        public void setLastModified(long value) {
            super.setLastModified(value);
            this.timeStampInitialized = true;
        }
    }
}

