/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.AbstractOperationAuthorizer;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class RealmOperationAuthorizer<T extends SecurityItem>
extends AbstractOperationAuthorizer<ISession> {
    private final Set<String> itemIDs;

    public RealmOperationAuthorizer(String operationID, Set<String> itemIDs) {
        super(operationID);
        this.itemIDs = itemIDs;
    }

    public final Set<String> getItemIDs() {
        return this.itemIDs;
    }

    protected String authorizeOperation(ISession session, Map<String, Object> parameters) {
        IRepository repository = session.getManager().getRepository();
        ISecurityManager securityManager = SecurityManagerUtil.getSecurityManager(repository);
        if (securityManager == null) {
            return "No security manager";
        }
        Realm realm = securityManager.getRealm();
        if (realm == null) {
            return "No realm";
        }
        String userID = session.getUserID();
        if (userID == null) {
            return "No user ID";
        }
        User user = realm.getUser(userID);
        if (user == null) {
            return "User " + userID + " is not authenticated";
        }
        Collection<T> items = this.getItemsOfUser(user);
        for (SecurityItem item : items) {
            if (!this.itemIDs.contains(this.getID(item))) continue;
            return null;
        }
        return "User " + userID + " is not authorized";
    }

    protected abstract Collection<T> getItemsOfUser(User var1);

    protected abstract String getID(T var1);

    public static abstract class Factory<T extends SecurityItem>
    extends AbstractOperationAuthorizer.Factory<ISession> {
        public Factory(String type) {
            super(type);
        }

        protected RealmOperationAuthorizer<T> create(String operationID, String description) throws ProductCreationException {
            HashSet<String> itemIDs = new HashSet<String>();
            if (description != null) {
                String[] stringArray = description.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemID = stringArray[n2];
                    if ((itemID = itemID.trim()).length() != 0) {
                        itemIDs.add(itemID);
                    }
                    ++n2;
                }
            }
            return this.create(operationID, itemIDs);
        }

        protected abstract RealmOperationAuthorizer<T> create(String var1, Set<String> var2) throws ProductCreationException;
    }

    public static final class RequireGroup
    extends RealmOperationAuthorizer<Group> {
        public RequireGroup(String operationID, Set<String> itemIDs) {
            super(operationID, itemIDs);
        }

        @Override
        protected Collection<Group> getItemsOfUser(User user) {
            return user.getAllGroups();
        }

        @Override
        protected String getID(Group group) {
            return group.getId();
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.server.internal.security.RealmOperationAuthorizer$Factory<Group> {
            public static final String TYPE = "requireGroup";

            public Factory() {
                super(TYPE);
            }

            protected RequireGroup create(String operationID, Set<String> itemIDs) throws ProductCreationException {
                return new RequireGroup(operationID, itemIDs);
            }
        }
    }

    public static final class RequireRole
    extends RealmOperationAuthorizer<Role> {
        public RequireRole(String operationID, Set<String> itemIDs) {
            super(operationID, itemIDs);
        }

        @Override
        protected Collection<Role> getItemsOfUser(User user) {
            return user.getAllRoles();
        }

        @Override
        protected String getID(Role role) {
            return role.getId();
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.server.internal.security.RealmOperationAuthorizer$Factory<Role> {
            public static final String TYPE = "requireRole";

            public Factory() {
                super(TYPE);
            }

            protected RequireRole create(String operationID, Set<String> itemIDs) throws ProductCreationException {
                return new RequireRole(operationID, itemIDs);
            }
        }
    }

    public static final class RequireUser
    extends RealmOperationAuthorizer<User> {
        public RequireUser(String operationID, Set<String> itemIDs) {
            super(operationID, itemIDs);
        }

        @Override
        protected Collection<User> getItemsOfUser(User user) {
            return Collections.singleton(user);
        }

        @Override
        protected String getID(User user) {
            return user.getId();
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.server.internal.security.RealmOperationAuthorizer$Factory<User> {
            public static final String TYPE = "requireUser";

            public Factory() {
                super(TYPE);
            }

            protected RequireUser create(String operationID, Set<String> itemIDs) throws ProductCreationException {
                return new RequireUser(operationID, itemIDs);
            }
        }
    }
}

