/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.h2.jdbcx.JdbcDataSource;

public class Server {
    public static void main(String[] args) throws Exception {
        OMPlatform.INSTANCE.setDebugging(true);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        Net4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        TCPUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        String name = "demo";
        IStore store = Server.createStore(name);
        Map<String, String> properties = Server.createProperties(name);
        IRepository repository = CDOServerUtil.createRepository((String)name, (IStore)store, properties);
        CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)repository);
        Net4jUtil.getAcceptor((IManagedContainer)IPluginContainer.INSTANCE, (String)"tcp", (String)"0.0.0.0:2036");
        while (System.in.available() == 0) {
            Thread.sleep(100L);
        }
        LifecycleUtil.deactivate((Object)repository);
        LifecycleUtil.deactivate((Object)IPluginContainer.INSTANCE);
    }

    private static IStore createStore(String name) {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:database/" + name);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    private static Map<String, String> createProperties(String name) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", name);
        props.put("supportingAudits", "true");
        props.put("supportingBranches", "true");
        return props;
    }
}

