/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.examples.company.CompanyFactory;
import org.eclipse.emf.cdo.examples.company.CompanyPackage;
import org.eclipse.emf.cdo.examples.company.Customer;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSessionRecoveryEvent;
import org.eclipse.emf.cdo.net4j.FailoverCDOSessionConfiguration;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositorySynchronizer;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ISynchronizableRepository;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.server.net4j.FailoverAgent;
import org.eclipse.emf.cdo.server.net4j.FailoverMonitor;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.server.InternalFailoverParticipant;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.h2.jdbcx.JdbcDataSource;

public abstract class FailoverExample {
    public static final String TRANSPORT_TYPE = "tcp";
    protected int port;
    protected String name;
    protected transient IManagedContainer container = FailoverExample.createContainer();
    protected transient IRepository repository;
    protected transient IAcceptor acceptor;

    static {
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
    }

    public static IManagedContainer createContainer() {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        TCPUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        return container;
    }

    public void init() {
        IStore store = this.createStore();
        Map<String, String> props = this.createProperties();
        this.repository = this.createRepository(store, props);
        CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)this.repository);
        this.repository.addListener(new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof RepositoryTypeChangedEvent) {
                    RepositoryTypeChangedEvent e = (RepositoryTypeChangedEvent)event;
                    System.out.println("Type changed to " + e.getNewType());
                } else if (event instanceof RepositoryStateChangedEvent) {
                    RepositoryStateChangedEvent e = (RepositoryStateChangedEvent)event;
                    System.out.println("State changed to " + e.getNewState());
                }
            }
        });
        this.connect();
    }

    public void run() throws Exception {
        String command;
        do {
            System.out.println();
            System.out.println("Enter a command:");
            this.showMenu();
            System.out.println();
        } while (!this.handleCommand(command = new BufferedReader(new InputStreamReader(System.in)).readLine()));
    }

    public void done() {
        LifecycleUtil.deactivate((Object)this.acceptor);
        LifecycleUtil.deactivate((Object)this.repository);
        this.container.deactivate();
    }

    protected void showMenu() {
        System.out.println("0 - exit");
        System.out.println("1 - connect repository to network");
        System.out.println("2 - disconnect repository from network");
        System.out.println("3 - dump repository infos");
    }

    protected boolean handleCommand(String command) {
        if ("1".equals(command)) {
            if (this.acceptor == null) {
                this.connect();
            } else {
                System.out.println("Already connected");
            }
        } else if ("2".equals(command)) {
            if (this.acceptor != null) {
                this.disconnect();
            } else {
                System.out.println("Already disconnected");
            }
        } else if ("3".equals(command)) {
            System.out.println();
            System.out.println(String.valueOf(this.repository.getName()) + ": " + this.repository.getType() + (this.repository.getType() == CDOCommonRepository.Type.BACKUP ? "|" + this.repository.getState() : ""));
        } else {
            if ("0".equals(command)) {
                System.out.println("Exiting...");
                return true;
            }
            System.out.println("Unknown command");
        }
        return false;
    }

    protected void connect() {
        System.out.println("Connecting to network...");
        this.acceptor = this.createAcceptor();
        System.out.println("Connected");
    }

    protected void disconnect() {
        System.out.println("Disconnecting from network...");
        LifecycleUtil.deactivate((Object)this.acceptor);
        this.acceptor = null;
        System.out.println("Disconnected");
    }

    protected IStore createStore() {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:_database/" + this.name);
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true);
        H2Adapter dbAdapter = new H2Adapter();
        IDBConnectionProvider dbConnectionProvider = dbAdapter.createConnectionProvider((DataSource)dataSource);
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
    }

    protected Map<String, String> createProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", this.name);
        props.put("supportingAudits", "true");
        props.put("supportingBranches", "true");
        return props;
    }

    protected abstract IRepository createRepository(IStore var1, Map<String, String> var2);

    protected IAcceptor createAcceptor() {
        return (IAcceptor)this.container.getElement("org.eclipse.net4j.acceptors", TRANSPORT_TYPE, "0.0.0.0:" + this.port);
    }

    protected IConnector createConnector(String description) {
        return Net4jUtil.getConnector((IManagedContainer)this.container, (String)TRANSPORT_TYPE, (String)description);
    }

    protected IRepositorySynchronizer createRepositorySynchronizer(String peerHost, int peerPort, String repositoryName) {
        CDOSessionConfigurationFactory factory = this.createSessionConfigurationFactory(String.valueOf(peerHost) + ":" + peerPort, repositoryName);
        IRepositorySynchronizer synchronizer = CDOServerUtil.createRepositorySynchronizer((CDOSessionConfigurationFactory)factory);
        synchronizer.setRetryInterval(2);
        synchronizer.setMaxRecommits(10);
        synchronizer.setRecommitInterval(2);
        return synchronizer;
    }

    protected CDOSessionConfigurationFactory createSessionConfigurationFactory(final String connectorDescription, final String repositoryName) {
        return new CDOSessionConfigurationFactory(){

            public CDONet4jSessionConfiguration createSessionConfiguration() {
                return FailoverExample.this.createSessionConfiguration(connectorDescription, repositoryName);
            }
        };
    }

    protected CDONet4jSessionConfiguration createSessionConfiguration(String connectorDescription, String repositoryName) {
        IConnector connector = this.createConnector(connectorDescription);
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(repositoryName);
        configuration.setRevisionManager(CDORevisionUtil.createRevisionManager((CDORevisionCache)CDORevisionCache.NOOP));
        return configuration;
    }

    public static class Monitored
    extends FailoverExample {
        public static final String REPOSITORY_GROUP = "ExampleGroup";
        public static final String REPOSITORY_MONITOR_HOST = "localhost";
        public static final int REPOSITORY_MONITOR_PORT = 2038;
        protected String host;

        public Monitored(String host, int port, String name) {
            this.host = host;
            this.port = port;
            this.name = name;
        }

        @Override
        protected IRepository createRepository(IStore store, Map<String, String> props) {
            ISynchronizableRepository repository = CDOServerUtil.createFailoverParticipant((String)this.name, (IStore)store, props);
            repository.setInitialPackages(new EPackage[]{CompanyPackage.eINSTANCE});
            ((InternalFailoverParticipant)repository).setAllowBackupCommits(true);
            FailoverAgent agent = new FailoverAgent(){

                protected CDOSessionConfiguration createSessionConfiguration(String connectorDescription, String repositoryName) {
                    return this.createSessionConfiguration(connectorDescription, repositoryName);
                }

                public IManagedContainer getContainer() {
                    return container;
                }
            };
            agent.setMonitorConnector(this.createConnector("localhost:2038"));
            agent.setConnectorDescription(String.valueOf(this.host) + ":" + this.port);
            agent.setRepository(repository);
            agent.setGroup(REPOSITORY_GROUP);
            agent.setRate(1000L);
            agent.setTimeout(4000L);
            agent.activate();
            return repository;
        }

        public static final class Agent1
        extends Monitored {
            public Agent1() {
                super(Monitored.REPOSITORY_MONITOR_HOST, 2036, "repo1");
            }

            public static void main(String[] args) throws Exception {
                Agent1 example = new Agent1();
                example.init();
                example.run();
                example.done();
            }
        }

        public static final class Agent2
        extends Monitored {
            public Agent2() {
                super(Monitored.REPOSITORY_MONITOR_HOST, 2037, "repo2");
            }

            public static void main(String[] args) throws Exception {
                Agent2 example = new Agent2();
                example.init();
                example.run();
                example.done();
            }
        }

        public static final class Client {
            public static void main(String[] args) throws Exception {
                IManagedContainer container = Monitored.createContainer();
                FailoverCDOSessionConfiguration configuration = CDONet4jUtil.createFailoverSessionConfiguration((String)"localhost:2038", (String)Monitored.REPOSITORY_GROUP, (IManagedContainer)container);
                CDONet4jSession session = configuration.openNet4jSession();
                System.out.println("Connected");
                final CDOTransaction tx = session.openTransaction();
                Client.addObject(tx);
                System.out.println("Succesfully committed an object to the original tx/session");
                session.addListener(new IListener(){

                    public void notifyEvent(IEvent event) {
                        if (event instanceof CDOSessionRecoveryEvent) {
                            CDOSessionRecoveryEvent e = (CDOSessionRecoveryEvent)event;
                            System.out.println("Failover " + e.getType() + ": " + e.getSource().getRepositoryInfo());
                            if (e.getType() == CDOSessionRecoveryEvent.Type.FINISHED) {
                                Client.addObject(tx);
                                System.out.println("Succesfully committed an object to the failed-over tx/session");
                            }
                        }
                    }
                });
                while (!session.isClosed()) {
                    Thread.sleep(100L);
                }
            }

            private static void addObject(CDOTransaction tx) {
                try {
                    Customer customer = CompanyFactory.eINSTANCE.createCustomer();
                    tx.getOrCreateResource("/r1").getContents().add((Object)customer);
                    tx.commit();
                }
                catch (CommitException x) {
                    throw new RuntimeException(x);
                }
            }
        }

        public static final class Monitor {
            public static void main(String[] args) throws Exception {
                IManagedContainer container = Monitored.createContainer();
                FailoverMonitor monitor = (FailoverMonitor)container.getElement("org.eclipse.emf.cdo.server.net4j.failoverMonitors", "net4j", Monitored.REPOSITORY_GROUP);
                monitor.addListener((IListener)new ContainerEventAdapter<FailoverMonitor.AgentProtocol>(){

                    protected void onAdded(IContainer<FailoverMonitor.AgentProtocol> monitor, FailoverMonitor.AgentProtocol agent) {
                        this.dump((FailoverMonitor)monitor, "Registered", agent);
                    }

                    protected void onRemoved(IContainer<FailoverMonitor.AgentProtocol> monitor, FailoverMonitor.AgentProtocol agent) {
                        this.dump((FailoverMonitor)monitor, "Deregistered", agent);
                    }

                    private void dump(FailoverMonitor monitor, String event, FailoverMonitor.AgentProtocol agent) {
                        System.out.println(String.valueOf(event) + " agent " + agent);
                        FailoverMonitor.AgentProtocol[] agentProtocolArray = monitor.getElements();
                        int n = agentProtocolArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FailoverMonitor.AgentProtocol element = agentProtocolArray[n2];
                            String type = element == monitor.getMasterAgent() ? "MASTER: " : "BACKUP: ";
                            System.out.println("   " + type + element);
                            ++n2;
                        }
                    }
                });
                container.getElement("org.eclipse.net4j.acceptors", FailoverExample.TRANSPORT_TYPE, "0.0.0.0:2038");
                System.out.println("Monitoring...");
                while (true) {
                    Thread.sleep(100L);
                }
            }
        }
    }

    public static class Unmonitored
    extends FailoverExample {
        protected boolean master;
        protected String peerHost;
        protected int peerPort;
        protected String peerRepository;

        public Unmonitored(int port, String name, boolean master, String peerHost, int peerPort, String peerRepository) {
            this.port = port;
            this.name = name;
            this.master = master;
            this.peerHost = peerHost;
            this.peerPort = peerPort;
            this.peerRepository = peerRepository;
        }

        @Override
        protected IRepository createRepository(IStore store, Map<String, String> props) {
            IRepositorySynchronizer synchronizer = this.createRepositorySynchronizer(this.peerHost, this.peerPort, this.peerRepository);
            ISynchronizableRepository repository = CDOServerUtil.createFailoverParticipant((String)this.name, (IStore)store, props, (IRepositorySynchronizer)synchronizer, (boolean)this.master);
            repository.setInitialPackages(new EPackage[]{CompanyPackage.eINSTANCE});
            return repository;
        }

        @Override
        protected void showMenu() {
            super.showMenu();
            System.out.println("4 - set repository type MASTER");
            System.out.println("5 - set repository type BACKUP");
        }

        @Override
        protected boolean handleCommand(String command) {
            if ("4".equals(command)) {
                if (this.repository.getType() == CDOCommonRepository.Type.BACKUP) {
                    System.out.println("Setting repository type MASTER...");
                    ((InternalRepository)this.repository).setType(CDOCommonRepository.Type.MASTER);
                    System.out.println("Type is " + this.repository.getType());
                } else {
                    System.out.println("Already MASTER");
                }
            } else if ("5".equals(command)) {
                if (this.repository.getType() == CDOCommonRepository.Type.MASTER) {
                    System.out.println("Setting repository type BACKUP...");
                    ((InternalRepository)this.repository).setType(CDOCommonRepository.Type.BACKUP);
                    System.out.println("Type is " + this.repository.getType());
                } else {
                    System.out.println("Already BACKUP");
                }
            } else {
                return super.handleCommand(command);
            }
            return false;
        }

        public static final class InitialBackup
        extends Unmonitored {
            public InitialBackup() {
                super(2037, "repo2", false, "localhost", 2036, "repo1");
            }

            public static void main(String[] args) throws Exception {
                InitialBackup example = new InitialBackup();
                example.init();
                example.run();
                example.done();
            }
        }

        public static final class InitialMaster
        extends Unmonitored {
            public InitialMaster() {
                super(2036, "repo1", true, "localhost", 2037, "repo2");
            }

            public static void main(String[] args) throws Exception {
                InitialMaster example = new InitialMaster();
                example.init();
                example.run();
                example.done();
            }
        }
    }
}

