/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples;

import java.util.HashMap;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.examples.company.Category;
import org.eclipse.emf.cdo.examples.company.CompanyFactory;
import org.eclipse.emf.cdo.examples.company.Product;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.mem.MEMStoreUtil;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.OMPlatform;

public class ImportXML {
    private static final String REPOSITORY_NAME = "repo1";

    public static void main(String[] args) throws CommitException {
        OMPlatform.INSTANCE.setDebugging(true);
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        JVMUtil.getAcceptor((IManagedContainer)container, (String)"default");
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)ImportXML.createRepository());
        IJVMConnector connector = JVMUtil.getConnector((IManagedContainer)container, (String)"default");
        CDOSession session = ImportXML.openSession((IConnector)connector);
        CDOTransaction transaction = session.openTransaction();
        CDOResource resource = transaction.createResource("/my/big/resource");
        EObject inputModel = ImportXML.getInputModel();
        resource.getContents().add((Object)inputModel);
        transaction.commit();
        session.close();
        connector.close();
    }

    private static IRepository createRepository() {
        HashMap props = new HashMap();
        return CDOServerUtil.createRepository((String)REPOSITORY_NAME, (IStore)ImportXML.createStore(), props);
    }

    private static IStore createStore() {
        return MEMStoreUtil.createMEMStore();
    }

    private static EObject getInputModel() {
        Category cat1 = CompanyFactory.eINSTANCE.createCategory();
        cat1.setName("CAT1");
        Category cat2 = CompanyFactory.eINSTANCE.createCategory();
        cat2.setName("CAT2");
        cat1.getCategories().add((Object)cat2);
        Product p1 = CompanyFactory.eINSTANCE.createProduct();
        p1.setName("P1");
        cat1.getProducts().add((Object)p1);
        Product p2 = CompanyFactory.eINSTANCE.createProduct();
        p2.setName("P2");
        cat1.getProducts().add((Object)p2);
        Product p3 = CompanyFactory.eINSTANCE.createProduct();
        p3.setName("P3");
        cat2.getProducts().add((Object)p3);
        return cat1;
    }

    protected static CDOSession openSession(IConnector connector) {
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector(connector);
        configuration.setRepositoryName(REPOSITORY_NAME);
        return configuration.openNet4jSession();
    }
}

